package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.WeekResourceDetailEntity;
/**
 * 周计划资源排布
 * 
 * @author generator
 * 
 */
 @TableName("oa_week_resource")
public class WeekResourceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="cur_month")
    private Date curMonth; // 所属月份
    @TableField(value="week_num")
    private Integer weekNum; // 第几周
    @TableField(value="bill_date")
    private Date billDate; // 创建日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="weekResourceDetailService", pidName = "weekResourceId")
    private List<WeekResourceDetailEntity> weekResourceDetailList = new ArrayList<>(); // 周计划资源排布-计划明细
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(Date curMonth) {
        this.curMonth = curMonth;
    }
    public Integer getWeekNum() {
        return weekNum;
    }

    public void setWeekNum(Integer weekNum) {
        this.weekNum = weekNum;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    

    public List<WeekResourceDetailEntity> getWeekResourceDetailList() {
        return weekResourceDetailList;
    }

    public void setWeekResourceDetailList(List<WeekResourceDetailEntity> weekResourceDetailList) {
        this.weekResourceDetailList = weekResourceDetailList;
    }
}
