package com.ejianc.business.procBid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 物资设备类招标文件会签表
 * 
 * @author generator
 * 
 */
public class BidDocVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 填写日期
    private String billCode; // 编码规则
    private Integer billState; // 单据状态（审批必须字段）
    private Long orgId; // 组织ID
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private Long purchaseId; // 采购事项ID
    private String purchaseCode; // 采购事项编码
    private String purchaseName; // 采购事项名称
    private String procType; // 招采类型
    private BigDecimal estimatedMny; // 预估标的物金额
    private String procMethod; // 招标方式(拟采购方式)

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date approvedTime; // 审批通过时间
    

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode="proc-report-manager")
    public Long getPurchaseId() {
        return purchaseId;
    }
    @ReferDeserialTransfer
    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseCode() {
        return purchaseCode;
    }

    public void setPurchaseCode(String purchaseCode) {
        this.purchaseCode = purchaseCode;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public String getProcType() {
        return procType;
    }

    public void setProcType(String procType) {
        this.procType = procType;
    }
    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }
    public String getProcMethod() {
        return procMethod;
    }

    public void setProcMethod(String procMethod) {
        this.procMethod = procMethod;
    }

    public Date getApprovedTime() {
        return approvedTime;
    }

    public void setApprovedTime(Date approvedTime) {
        this.approvedTime = approvedTime;
    }
    
}
