/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CertApplyDetailEntity;
import com.ejianc.business.oa.bean.CertApplyEntity;
import com.ejianc.business.oa.mapper.CertApplyMapper;
import com.ejianc.business.oa.service.ICertApplyService;
import com.ejianc.business.oa.vo.CertApplyListVO;
import com.ejianc.business.oa.vo.CertApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="certApplyService")
public class CertApplyServiceImpl
extends BaseServiceImpl<CertApplyMapper, CertApplyEntity>
implements ICertApplyService {
    private static final String CERT_APPLY_BILL_CODE = "CERT_APPLY";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<CertApplyVO> saveOrUpdate(CertApplyVO certApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CertApplyEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)certApplyVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CERT_APPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                certApplyVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity = (CertApplyEntity)((Object)BeanMapper.map((Object)certApplyVO, CertApplyEntity.class));
        List<CertApplyDetailEntity> applyDetail = entity.getCertApplyDetail();
        String certName = "";
        if (applyDetail != null && applyDetail.size() > 0) {
            List certNameList = applyDetail.stream().filter(e -> e.getRowState() == null || !e.getRowState().equals("del")).map(CertApplyDetailEntity::getCertName).collect(Collectors.toList());
            List certNames = certNameList.stream().distinct().collect(Collectors.toList());
            for (String cert : certNames) {
                certName = certName + cert + ",";
            }
            String substring = certName.substring(0, certName.length() - 1);
            entity.setCertName(substring);
            entity.setApplyNum(certNameList.size());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), CertApplyVO.class));
    }

    @Override
    public List<CertApplyListVO> getDealList(Page<CertApplyListVO> page, QueryWrapper wrapper) {
        List<CertApplyListVO> list = ((CertApplyMapper)this.baseMapper).getDealList(page, wrapper);
        return list;
    }
}

