package com.ejianc.business.oa.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.oa.controller.query.WeeklyReportQuery;
import com.ejianc.business.oa.vo.*;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 周报
 *
 * @author generator
 *
 */
public interface IWeeklyReportService extends IBaseService<WeeklyReportEntity> {

    WeeklyReportVO saveOrUpdate(WeeklyReportVO weeklyReportVO);

    WeeklyReportVO afterProject(Long id, Long projectId, Integer weeklyNum);

    IPage<WeeklyReportVO> queryReportList(WeeklyReportQuery query);

    IPage<WeeklyReportVO> queryProblemList(QueryParam param);

    Map<Long, ProjectDurationVO> selectStartWorkReportTimeAndTermByProjectId(List<Long>  projectId);

    Integer queryWeeklyNum(WeeklyReportQuery query);

    // 根据projectId查询项目年度指标计划的”年度计划产值“字段
    BigDecimal queryPlanOutputByProjectId(Long projectId);

    // 根据projectId查询开工报告
    MarketStartWorkReportVO queryStartWorkReportByProjectId(Long projectId);

    // 根据projectId查询项目年度指标计划
    HkReturnPlanVO queryReturnPlanByProjectId(Long projectId);

    // 根据projectId查询收款登记
    FinanceReceiveVO queryReceiveByProjectId(Long projectId);

    // 根据projectId查询项目管理人员
    List<WeeklyProjectManagerVO> queryProjectManagerByProjectId(Long projectId);
}
