/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.service.ISealApplyService;
import com.ejianc.business.oa.vo.SealApplyExportVO;
import com.ejianc.business.oa.vo.SealApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sealApply"})
public class SealApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "seal-use-code001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISealApplyService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String PARAM_VIEW_CODE = "P-1392GB56";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SealApplyVO> saveOrUpdate(@RequestBody SealApplyVO saveorUpdateVO) {
        SealApplyVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SealApplyVO> queryDetail(Long id) {
        SealApplyVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SealApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SealApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SealApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (!this.canViewAll().booleanValue()) {
            queryParam.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        IPage voPage = this.service.queryPage(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            SealApplyExportVO exportVO = (SealApplyExportVO)BeanMapper.map((Object)vo, SealApplyExportVO.class);
            if (vo.getApplyDate() != null) {
                exportVO.setApplyDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getApplyDate()));
            }
            exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        String fileName = "sealApplyExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }
}

