/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.oa.bean.MonthBudgetFormEntity;
import com.ejianc.business.oa.mapper.MonthBudgetFormMapper;
import com.ejianc.business.oa.service.IMonthBudgetFormService;
import com.ejianc.business.oa.vo.ImportMonthBudgetFormDetailVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="monthBudgetFormService")
public class MonthBudgetFormServiceImpl
extends BaseServiceImpl<MonthBudgetFormMapper, MonthBudgetFormEntity>
implements IMonthBudgetFormService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportMonthBudgetFormDetailVO> successList = new ArrayList<ImportMonthBudgetFormDetailVO>();
        ArrayList<ImportMonthBudgetFormDetailVO> errorList = new ArrayList<ImportMonthBudgetFormDetailVO>();
        HashMap projectMap = new HashMap();
        QueryParam queryProjectParam = new QueryParam();
        HashMap employeeMap = new HashMap();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 10) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                ImportMonthBudgetFormDetailVO importVO = new ImportMonthBudgetFormDetailVO();
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVO.setPersonCode(((String)datas.get(0)).trim());
                    if (((String)datas.get(0)).length() > 64) {
                        errorMessage.append("[\u5458\u5de5\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (employeeMap.get(datas.get(0)) != null) {
                        errorMessage.append("[\u5458\u5de5\u91cd\u590d\u6dfb\u52a0]");
                    } else {
                        CommonResponse employeeData = this.employeeApi.getByEmpmloyeeCode(importVO.getPersonCode());
                        if (!employeeData.isSuccess()) {
                            errorMessage.append("[\u4eba\u5458\u7ba1\u7406\u4e2d\u6ca1\u6709\u5f53\u524d\u5458\u5de5\u7f16\u7801\u7684\u4eba\u5458]");
                        } else if (null != employeeData.getData()) {
                            employeeMap.put(datas.get(0), employeeData.getData());
                            importVO.setPersonId(((EmployeeVO)employeeMap.get(datas.get(0))).getId());
                            importVO.setPersonName(((EmployeeVO)employeeMap.get(datas.get(0))).getName());
                        } else {
                            errorMessage.append("[\u4eba\u5458\u7ba1\u7406\u4e2d\u6ca1\u6709\u5f53\u524d\u5458\u5de5\u7f16\u7801\u7684\u4eba\u5458]");
                        }
                    }
                } else {
                    errorMessage.append("[\u5458\u5de5\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u59d3\u540d\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setPersonName(((String)datas.get(1)).trim());
                    if (employeeMap.get(datas.get(0)) == null || !importVO.getPersonName().equals(((EmployeeVO)employeeMap.get(datas.get(0))).getName())) {
                        errorMessage.append("[\u59d3\u540d\u548c\u5458\u5de5\u7f16\u7801\u4e0d\u5339\u914d]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    try {
                        importVO.setUnitSocialSecurityMny(new BigDecimal((String)datas.get(2)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u5355\u4f4d\u793e\u4fdd\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    errorMessage.append("[\u5355\u4f4d\u7f34\u7eb3\u5f52\u5c5e\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setUnitPayBelong(((String)datas.get(3)).trim());
                    if (!("\u4e2a\u4eba".equals(datas.get(3)) || "\u516c\u53f8".equals(datas.get(3)) || "\u9879\u76ee".equals(datas.get(3)))) {
                        errorMessage.append("[\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5355\u4f4d\u7f34\u7eb3\u5f52\u5c5e]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    try {
                        importVO.setPersonSocialSecurityMny(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u4e2a\u4eba\u793e\u4fdd\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        importVO.setPayMny(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u652f\u51fa\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importVO.setIncomeMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u6536\u5165\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        errorMessage.append("[\u672a\u586b\u5199\u9879\u76ee\u540d\u79f0]");
                    }
                    importVO.setProjectCode(((String)datas.get(8)).trim());
                    if (((String)datas.get(8)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u9879\u76ee\u7f16\u7801\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (projectMap.get(datas.get(8)) != null) {
                        importVO.setProjectId(((ProjectRegisterVO)projectMap.get(datas.get(8))).getId());
                        importVO.setProjectName(((ProjectRegisterVO)projectMap.get(datas.get(8))).getName());
                    } else {
                        queryProjectParam.getParams().put("withoutOrgFlag", new Parameter("eq", (Object)true));
                        queryProjectParam.getParams().put("status", new Parameter("eq", (Object)2));
                        queryProjectParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
                        queryProjectParam.getParams().put("code", new Parameter("eq", (Object)((String)datas.get(8)).trim()));
                        CommonResponse projectData = this.projectApi.queryAllProj(queryProjectParam);
                        if (!projectData.isSuccess()) {
                            errorMessage.append("[\u9879\u76ee\u7acb\u9879\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u5728\u5efa\u3001\u542f\u7528\u9879\u76ee]");
                        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)projectData.getData())) && null != ((List)projectData.getData()).get(0)) {
                            projectMap.put(datas.get(8), ((List)projectData.getData()).get(0));
                            importVO.setProjectId(((ProjectRegisterVO)projectMap.get(datas.get(8))).getId());
                            importVO.setProjectName(((ProjectRegisterVO)projectMap.get(datas.get(8))).getName());
                        } else {
                            errorMessage.append("[\u9879\u76ee\u7acb\u9879\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u5728\u5efa\u3001\u542f\u7528\u9879\u76ee]");
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    importVO.setProjectName(((String)datas.get(7)).trim());
                    if (projectMap.get(datas.get(8)) == null || !importVO.getProjectName().equals(((ProjectRegisterVO)projectMap.get(datas.get(8))).getName())) {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u4e0d\u5339\u914d]");
                    }
                }
                if (((String)datas.get(9)).length() > 200) {
                    importVO.setErrorMessage("\u586b\u5199\u5907\u6ce8\u957f\u5ea6\u4e3a0~200\u5b57");
                }
                importVO.setMemo((String)datas.get(9));
                importVO.setId(Long.valueOf(IdWorker.getId()));
                importVO.setSourceType(Integer.valueOf(1));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

