/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procBid.utils;

import com.ejianc.business.procBid.utils.CellModel;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;

public class ExportExcelUtil {
    public static void export(String fileName, List<List<Object>> data, Map<String, List<CellModel>> headerMap, HttpServletResponse response) {
        ExportExcelUtil.export(null, (Integer)0, fileName, data, headerMap, response);
    }

    /*
     * WARNING - void declaration
     */
    public static void export(String templatePath, Integer skipRows, String fileName, List<List<Object>> data, Map<String, List<CellModel>> cellTitleMap, HttpServletResponse response) {
        XSSFWorkbook workbook = null;
        OutputStream out = null;
        Sheet sheet = null;
        try {
            if (templatePath != null && !templatePath.isEmpty()) {
                ClassPathResource resource = new ClassPathResource("excel/" + templatePath);
                if (!resource.exists()) {
                    throw new RuntimeException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728: " + resource.getPath());
                }
                try {
                    InputStream inputStream = resource.getInputStream();
                    Object object = null;
                    try {
                        workbook = WorkbookFactory.create((InputStream)inputStream);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            if (object != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("\u52a0\u8f7d\u6a21\u677f\u6587\u4ef6\u65f6\u51fa\u9519: " + resource.getPath(), e);
                }
                sheet = workbook.getSheetAt(0);
            } else {
                void var12_20;
                workbook = new XSSFWorkbook();
                sheet = workbook.createSheet("sheet1");
                XSSFCellStyle cellStyle = (XSSFCellStyle)workbook.createCellStyle();
                XSSFColor lightBlueColor = new XSSFColor(new Color(153, 204, 255));
                cellStyle.setFillForegroundColor(lightBlueColor);
                cellStyle.setFillPattern((short)1);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setWrapText(true);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderRight((short)1);
                cellStyle.setBorderTop((short)1);
                Font font = workbook.createFont();
                font.setFontHeightInPoints((short)14);
                font.setFontName("\u5b8b\u4f53");
                font.setBoldweight((short)700);
                cellStyle.setFont(font);
                boolean bl = false;
                while (var12_20 <= skipRows) {
                    Cell cell;
                    Row row = sheet.createRow((int)var12_20);
                    List<CellModel> cellNameList = cellTitleMap.get(String.valueOf((int)var12_20));
                    for (CellModel cellModel : cellNameList) {
                        if (cellModel.getStartColumn() == null) continue;
                        cell = row.createCell(cellModel.getStartColumn().intValue());
                        cell.setCellValue(cellModel.getCellName());
                        cell.setCellStyle((CellStyle)cellStyle);
                    }
                    if (var12_20 != false) {
                        int lastCellNum = sheet.getRow(0).getLastCellNum();
                        for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                            cell = sheet.getRow((int)var12_20).getCell(cellIndex);
                            if (cell == null) {
                                cell = sheet.getRow((int)var12_20).createCell(cellIndex);
                                cell.setCellValue("");
                            }
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                    }
                    for (CellModel cellModel : cellNameList) {
                        if (cellModel.getStartRow() != null) {
                            CellRangeAddress region = new CellRangeAddress(cellModel.getStartRow().intValue(), cellModel.getEndRow().intValue(), cellModel.getStartColumn().intValue(), cellModel.getEndColumn().intValue());
                            sheet.addMergedRegion(region);
                            RegionUtil.setBorderBottom((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderLeft((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderRight((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderTop((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                        }
                        if (cellModel.getWidth() != null) {
                            sheet.setColumnWidth(cellModel.getStartColumn().intValue(), cellModel.getWidth() * 256);
                            continue;
                        }
                        sheet.setColumnWidth(cellModel.getStartColumn().intValue(), cellModel.getCellName().getBytes().length * 256);
                    }
                    ++var12_20;
                }
            }
            CellStyle cellDataStyle = workbook.createCellStyle();
            cellDataStyle.setAlignment((short)2);
            cellDataStyle.setVerticalAlignment((short)1);
            cellDataStyle.setWrapText(true);
            cellDataStyle.setBorderBottom((short)1);
            cellDataStyle.setBorderLeft((short)1);
            cellDataStyle.setBorderRight((short)1);
            cellDataStyle.setBorderTop((short)1);
            int startRow = skipRows + 1;
            for (List list : data) {
                Row rowValue = sheet.createRow(startRow);
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    Cell cell = rowValue.createCell(i);
                    if (value != null) {
                        if (value instanceof String) {
                            cell.setCellValue((String)value);
                        } else if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                        } else if (value instanceof Long) {
                            cell.setCellValue((double)((Long)value).longValue());
                        } else if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                        } else if (value instanceof Boolean) {
                            cell.setCellValue(((Boolean)value).booleanValue());
                        } else if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                            cell.setCellStyle(cellDataStyle);
                        } else if (value instanceof Float) {
                            cell.setCellValue((double)((Float)value).floatValue());
                        } else if (value instanceof BigDecimal) {
                            cell.setCellValue(((BigDecimal)value).doubleValue());
                        } else {
                            cell.setCellValue(value.toString());
                        }
                    } else {
                        cell.setCellValue("");
                    }
                    cell.setCellStyle(cellDataStyle);
                }
                ++startRow;
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setCharacterEncoding("UTF-8");
            out = response.getOutputStream();
            workbook.write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void export(String templatePath, Integer skipRows, String fileName, Iterable<?> data, Map<String, List<CellModel>> cellTitleMap, HttpServletResponse response) {
        XSSFWorkbook workbook = null;
        OutputStream out = null;
        Sheet sheet = null;
        try {
            if (templatePath != null && !templatePath.isEmpty()) {
                ClassPathResource resource = new ClassPathResource("excel/" + templatePath);
                if (!resource.exists()) {
                    throw new RuntimeException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728: " + resource.getPath());
                }
                try (InputStream inputStream = resource.getInputStream();){
                    workbook = WorkbookFactory.create((InputStream)inputStream);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u52a0\u8f7d\u6a21\u677f\u6587\u4ef6\u65f6\u51fa\u9519: " + resource.getPath(), e);
                }
                sheet = workbook.getSheetAt(0);
            } else {
                workbook = new XSSFWorkbook();
                sheet = workbook.createSheet("sheet1");
                XSSFCellStyle cellStyle = (XSSFCellStyle)workbook.createCellStyle();
                XSSFColor lightBlueColor = new XSSFColor(new Color(153, 204, 255));
                cellStyle.setFillForegroundColor(lightBlueColor);
                cellStyle.setFillPattern((short)1);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setWrapText(true);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderRight((short)1);
                cellStyle.setBorderTop((short)1);
                Font font = workbook.createFont();
                font.setFontHeightInPoints((short)14);
                font.setFontName("\u5b8b\u4f53");
                font.setBoldweight((short)700);
                cellStyle.setFont(font);
                for (int t = 0; t <= skipRows; ++t) {
                    Cell cell;
                    Row row = sheet.createRow(t);
                    List<CellModel> cellNameList = cellTitleMap.get(String.valueOf(t));
                    for (CellModel cellModel : cellNameList) {
                        if (cellModel.getStartColumn() == null) continue;
                        cell = row.createCell(cellModel.getStartColumn().intValue());
                        cell.setCellValue(cellModel.getCellName());
                        cell.setCellStyle((CellStyle)cellStyle);
                    }
                    if (t != 0) {
                        int lastCellNum = sheet.getRow(0).getLastCellNum();
                        for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                            cell = sheet.getRow(t).getCell(cellIndex);
                            if (cell == null) {
                                cell = sheet.getRow(t).createCell(cellIndex);
                                cell.setCellValue("");
                            }
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                    }
                    for (CellModel cellModel : cellNameList) {
                        if (cellModel.getStartRow() != null) {
                            CellRangeAddress region = new CellRangeAddress(cellModel.getStartRow().intValue(), cellModel.getEndRow().intValue(), cellModel.getStartColumn().intValue(), cellModel.getEndColumn().intValue());
                            sheet.addMergedRegion(region);
                            RegionUtil.setBorderBottom((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderLeft((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderRight((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                            RegionUtil.setBorderTop((int)1, (CellRangeAddress)region, (Sheet)sheet, (Workbook)workbook);
                        }
                        if (cellModel.getWidth() != null) {
                            sheet.setColumnWidth(cellModel.getStartColumn().intValue(), cellModel.getWidth() * 256);
                            continue;
                        }
                        sheet.setColumnWidth(cellModel.getStartColumn().intValue(), cellModel.getCellName().getBytes().length * 256);
                    }
                }
            }
            CellStyle cellDataStyle = workbook.createCellStyle();
            cellDataStyle.setAlignment((short)2);
            cellDataStyle.setVerticalAlignment((short)1);
            cellDataStyle.setWrapText(true);
            cellDataStyle.setBorderBottom((short)1);
            cellDataStyle.setBorderLeft((short)1);
            cellDataStyle.setBorderRight((short)1);
            cellDataStyle.setBorderTop((short)1);
            int startRow = skipRows + 1;
            Iterator<?> iterator = data.iterator();
            if (iterator.hasNext()) {
                Object firstItem = iterator.next();
                Class<?> clazz = firstItem.getClass();
                Field[] fields = clazz.getDeclaredFields();
                for (Field field : fields) {
                    field.setAccessible(true);
                }
                int rowIndex = startRow;
                do {
                    Object item = firstItem;
                    if (rowIndex > startRow) {
                        if (!iterator.hasNext()) break;
                        item = iterator.next();
                    }
                    Row row = sheet.createRow(rowIndex++);
                    int fieldIndex = 0;
                    for (Field field : fields) {
                        Object value = null;
                        try {
                            value = field.get(item);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            continue;
                        }
                        Cell cell = row.createCell(fieldIndex++);
                        if (value != null) {
                            if (value instanceof String) {
                                cell.setCellValue((String)value);
                            } else if (value instanceof Double) {
                                cell.setCellValue(((Double)value).doubleValue());
                            } else if (value instanceof Long) {
                                cell.setCellValue((double)((Long)value).longValue());
                            } else if (value instanceof Integer) {
                                cell.setCellValue((double)((Integer)value).intValue());
                            } else if (value instanceof Boolean) {
                                cell.setCellValue(((Boolean)value).booleanValue());
                            } else if (value instanceof Date) {
                                cell.setCellValue((Date)value);
                                cell.setCellStyle(cellDataStyle);
                            } else if (value instanceof Float) {
                                cell.setCellValue((double)((Float)value).floatValue());
                            } else if (value instanceof BigDecimal) {
                                cell.setCellValue(((BigDecimal)value).doubleValue());
                            } else {
                                cell.setCellValue(value.toString());
                            }
                        } else {
                            cell.setCellValue("");
                        }
                        cell.setCellStyle(cellDataStyle);
                    }
                } while (iterator.hasNext());
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setCharacterEncoding("UTF-8");
            out = response.getOutputStream();
            workbook.write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

