/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.EmployeeEntity;
import com.ejianc.foundation.oms.bean.JobEntity;
import com.ejianc.foundation.oms.bean.UserEntity;
import com.ejianc.foundation.oms.mapper.EmployeeMapper;
import com.ejianc.foundation.oms.service.IEmployeeService;
import com.ejianc.foundation.oms.service.IJobService;
import com.ejianc.foundation.oms.vo.EmployeeVO;
import com.ejianc.foundation.oms.vo.JobVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeServiceImpl
extends BaseServiceImpl<EmployeeMapper, EmployeeEntity>
implements IEmployeeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private IJobService jobService;

    @Override
    @Transactional
    public EmployeeEntity save(EmployeeVO employeeVO, UserEntity user) {
        this.checkInfo(employeeVO);
        employeeVO.setState(1);
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setUserId(user.getId());
        employeeVO.setId(user.getId());
        employeeVO.setSequence(1);
        employeeVO.setWorkTime(new Date());
        EmployeeEntity dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)((Object)employeeVO), EmployeeEntity.class));
        super.saveOrUpdate((Object)dbEntity, false);
        JobEntity job = this.generateJob(employeeVO);
        this.jobService.saveOrUpdate((Object)job, false);
        return dbEntity;
    }

    public JobEntity generateJob(EmployeeVO employeeVO) {
        JobEntity vo = new JobEntity();
        vo.setProperty(JobVO.JOB_TYPE_MAIN);
        vo.setEmployeeId(employeeVO.getId());
        vo.setCurState(JobVO.STATE_ACTIVE);
        vo.setJobStartTime(employeeVO.getWorkTime());
        vo.setOrgId(employeeVO.getOrgId());
        vo.setDr(BaseVO.DR_UNDELETE);
        vo.setTenantId(employeeVO.getTenantId());
        return vo;
    }

    @Override
    public List<EmployeeEntity> getAllByIds(List<Long> employeeIds) {
        return ((EmployeeMapper)this.baseMapper).selectBatchIds(employeeIds);
    }

    @Override
    public EmployeeVO queryEmployeeByUserId(Long userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)userId);
        List entities = this.employeeMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            return (EmployeeVO)((Object)BeanMapper.map(entities.get(0), EmployeeVO.class));
        }
        return null;
    }

    private void checkInfo(EmployeeVO employeeVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mobilePhone", new Parameter("eq", (Object)employeeVO.getMobilePhone()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List list = this.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u4fdd\u5b58\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8be5\u79df\u6237\u6ce8\u518c\u624b\u673a\u53f7\u5df2\u88ab\u4eba\u5458id\u4e3a\u3010" + ((EmployeeEntity)((Object)list.get(0))).getId() + "\u3011\u7684\u7528\u6237\u4f7f\u7528\uff01");
        }
    }
}

