/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.initData.api.InitDataApi;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.oms.bean.DefaultPwdEntity;
import com.ejianc.foundation.oms.bean.EnterpriseEntity;
import com.ejianc.foundation.oms.bean.OrgEntity;
import com.ejianc.foundation.oms.bean.PasswordPolicyEntity;
import com.ejianc.foundation.oms.bean.TenantEntity;
import com.ejianc.foundation.oms.bean.UserEntity;
import com.ejianc.foundation.oms.mapper.EnterpriseMapper;
import com.ejianc.foundation.oms.service.IDefaultpwdService;
import com.ejianc.foundation.oms.service.IEmployeeService;
import com.ejianc.foundation.oms.service.IEnterpriseService;
import com.ejianc.foundation.oms.service.IOrgService;
import com.ejianc.foundation.oms.service.IPasswordPolicyService;
import com.ejianc.foundation.oms.service.ITenantService;
import com.ejianc.foundation.oms.service.IUserService;
import com.ejianc.foundation.oms.vo.EmployeeVO;
import com.ejianc.foundation.oms.vo.EnterpriseVO;
import com.ejianc.foundation.oms.vo.PasswordPolicyVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriseServiceImpl
extends BaseServiceImpl<EnterpriseMapper, EnterpriseEntity>
implements IEnterpriseService {
    @Autowired
    ITenantService iTenantService;
    @Autowired
    IPasswordPolicyService iPasswordPolicyService;
    @Autowired
    IDefaultpwdService iDefaultpwdService;
    @Autowired
    IOrgService iOrgService;
    @Autowired
    IUserService iUserService;
    @Autowired
    InitDataApi initDataApi;
    @Autowired
    IEmployeeService iEmployeeService;

    @Override
    public EnterpriseVO selectById(Long enterpriseId) {
        EnterpriseEntity entity = (EnterpriseEntity)((Object)this.getById(enterpriseId));
        if (entity != null) {
            EnterpriseVO enterpriseVo = (EnterpriseVO)((Object)BeanMapper.map((Object)((Object)entity), EnterpriseVO.class));
            return enterpriseVo;
        }
        return null;
    }

    @Override
    public EnterpriseVO queryEnterpriseByTenantId(Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        List entities = ((EnterpriseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (entities != null) {
            return (EnterpriseVO)((Object)BeanMapper.map(entities.get(0), EnterpriseVO.class));
        }
        return null;
    }

    @Override
    @Transactional
    public void approvalPassed(EnterpriseEntity entity) {
        UserEntity userEntity = this.iUserService.getById(entity.getUserId());
        if (userEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u521b\u5efa\u4f01\u4e1a\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        Long tenantId = IdWorker.getId();
        Long passwordPolicyId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        entity.setTenantId(tenantId);
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenantId);
        tenantEntity.setTenantId(tenantId);
        tenantEntity.setName(entity.getName());
        tenantEntity.setCode("T" + tenantId);
        tenantEntity.setEnterpriseId(entity.getId());
        tenantEntity.setPasswordPolicyId(passwordPolicyId);
        tenantEntity.setState(1);
        PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
        passwordPolicyVO.setId(passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setCode("PP" + passwordPolicyId);
        PasswordPolicyEntity policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
        DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
        defaultPwdEntity.setId(IdWorker.getId());
        defaultPwdEntity.setTenantId(tenantId);
        defaultPwdEntity.setCreateTime(null);
        defaultPwdEntity.setUpdateTime(null);
        defaultPwdEntity.setUpdateUserCode(null);
        defaultPwdEntity.setCreateUserCode(null);
        defaultPwdEntity.setVersion(null);
        OrgEntity orgEntity = new OrgEntity();
        orgEntity.setId(orgId);
        orgEntity.setCode("BASE" + orgId);
        orgEntity.setEnterpriseId(entity.getId());
        orgEntity.setInnerCode(orgEntity.getId().toString());
        orgEntity.setState(1);
        orgEntity.setTenantId(tenantId);
        orgEntity.setName(entity.getName());
        orgEntity.setOrgType(1);
        orgEntity.setShortName(entity.getName());
        orgEntity.setManager(entity.getLegalName());
        orgEntity.setPhone(entity.getLegalTelephone());
        orgEntity.setSequence(1);
        EmployeeVO employeeVO = new EmployeeVO();
        employeeVO.setName(userEntity.getUserName());
        employeeVO.setCode("BASE-EMP" + employeeVO.getId());
        employeeVO.setEmployeeType(1);
        employeeVO.setSex(1);
        employeeVO.setMobilePhone(userEntity.getUserMobile());
        employeeVO.setOrgName(orgEntity.getName());
        employeeVO.setOrgId(orgId);
        employeeVO.setTenantId(tenantId);
        try {
            EnterpriseInitVO vo = (EnterpriseInitVO)BeanMapper.map((Object)((Object)entity), EnterpriseInitVO.class);
            this.initDataApi.initData(vo);
        }
        catch (Exception e) {
            this.initDataApi.rollBack(tenantId);
            throw new BusinessException("\u521d\u59cb\u5316\u652f\u6491\u4e2d\u5fc3\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
        try {
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
            this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
            this.iOrgService.saveOrUpdate((Object)orgEntity, false);
            this.iEmployeeService.save(employeeVO, userEntity);
        }
        catch (Exception e) {
            this.initDataApi.rollBack(tenantId);
            throw new BusinessException("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

