/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.OrgEntity;
import com.ejianc.foundation.oms.mapper.OrgMapper;
import com.ejianc.foundation.oms.service.IOrgService;
import com.ejianc.foundation.oms.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgServiceImpl
extends BaseServiceImpl<OrgMapper, OrgEntity>
implements IOrgService {
    @Autowired
    private OrgMapper orgMapper;

    @Override
    public List<OrgVO> queryListTree(Map<String, Object> params) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        Iterator<String> iterator = params.keySet().iterator();
        block8: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "orgId": {
                    Long orgId = (Long)params.get(key);
                    OrgEntity currentEntity = null;
                    if (orgId != null) {
                        currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(orgId));
                    }
                    if (currentEntity == null) continue block8;
                    if ("4".equals(currentEntity.getOrgType())) {
                        this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
                    }
                    query.likeRight((Object)"inner_code", (Object)currentEntity.getInnerCode());
                    continue block8;
                }
                case "orgTypes": {
                    query.in((Object)"org_type", (Collection)((List)params.get("orgTypes")));
                    continue block8;
                }
            }
            query.like((Object)CamelAndUnderLineConverter.humpToLine((String)key), params.get(key));
        }
        query.orderByAsc((Object)"sequence");
        query.orderByDesc((Object)"create_time");
        List eList = ((OrgMapper)this.baseMapper).selectList((Wrapper)query);
        return BeanMapper.mapList((Iterable)eList, OrgVO.class);
    }

    @Override
    public OrgVO queryDetail(Long id) {
        OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            return (OrgVO)((Object)BeanMapper.map((Object)((Object)entity), OrgVO.class));
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        ((OrgMapper)this.baseMapper).deleteById(id);
    }

    @Override
    public List<OrgVO> queryListByPid(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        wrapper.eq((Object)"dr", (Object)0);
        List entity = ((OrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entity != null) {
            return BeanMapper.mapList((Iterable)entity, OrgVO.class);
        }
        return null;
    }

    @Override
    public List<OrgVO> selectByMap(Map<String, Object> map) {
        List entity = ((OrgMapper)this.baseMapper).selectByMap(map);
        return BeanMapper.mapList((Iterable)entity, OrgVO.class);
    }

    @Override
    public List<OrgEntity> getAllByIds(List<Long> ids) {
        return ((OrgMapper)this.baseMapper).selectBatchIds(ids);
    }

    private void loopOrgEntityByPid(Long parentId, OrgEntity result) {
        OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(parentId));
        if (!"4".equals(entity.getOrgType())) {
            result = entity;
        } else if (entity.getParentId() != null && entity.getParentId() > 0L) {
            this.loopOrgEntityByPid(entity.getParentId(), result);
        } else {
            result = entity;
        }
    }

    @Override
    public OrgVO queryUserContextOrg(Long orgId) {
        OrgEntity currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(orgId));
        if (currentEntity != null && "4".equals(currentEntity.getOrgType())) {
            this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
        }
        if (currentEntity != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"parent_id", (Object)currentEntity.getId());
            Integer count = ((OrgMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
            OrgVO orgVo = (OrgVO)((Object)BeanMapper.map((Object)((Object)currentEntity), OrgVO.class));
            if (count != null && count > 0) {
                orgVo.setIsParent(true);
            }
            return orgVo;
        }
        return null;
    }

    @Override
    public List<OrgVO> getSubOrgs(Long orgId) {
        List<OrgVO> orgVoList = ((OrgMapper)this.baseMapper).getSubOrgs(orgId);
        return orgVoList;
    }

    @Override
    public List<OrgVO> searchOrgs(String searchText, String orgIds) {
        ArrayList<OrgVO> orgVos = new ArrayList<OrgVO>();
        if (StringUtils.isNotBlank((CharSequence)orgIds)) {
            String[] orgIdArr;
            for (String orgId : orgIdArr = orgIds.split(",")) {
                OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(Long.valueOf(Long.parseLong(orgId))));
                if (entity == null) continue;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.like((Object)"name", (Object)searchText);
                queryWrapper.likeRight((Object)"inner_code", (Object)entity.getInnerCode());
                queryWrapper.orderByAsc((Object)"inner_code");
                queryWrapper.orderByAsc((Object)"sequence");
                List orgEntities = ((OrgMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
                orgVos.addAll(BeanMapper.mapList((Iterable)orgEntities, OrgVO.class));
            }
        }
        return orgVos;
    }

    @Override
    public List<OrgVO> queryUserContextOrgList(List<Long> resultList) {
        StringBuffer orgIds = new StringBuffer("");
        if (resultList != null && resultList.size() > 0) {
            for (Long orgId : resultList) {
                orgIds.append(orgId).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)orgIds)) {
            String orgIdString = orgIds.substring(0, orgIds.length() - 1);
            return this.orgMapper.queryUserContextOrgList(orgIdString);
        }
        return null;
    }

    @Override
    public List<OrgVO> queryJobOrgs(Long userId) {
        List<OrgVO> orgList = this.orgMapper.queryJobOrgsByUserId(userId);
        return orgList;
    }

    @Override
    public List<OrgVO> queryAppSubByPid(Long orgId) {
        OrgEntity entity = (OrgEntity)((Object)this.orgMapper.selectById(orgId));
        if (entity != null) {
            List<OrgVO> result = this.orgMapper.queryAppSubByPid(entity.getInnerCode());
            return result;
        }
        return null;
    }

    @Override
    public List<OrgVO> findParentsByOrgId(Long orgId) {
        OrgEntity entity = (OrgEntity)((Object)this.orgMapper.selectById(orgId));
        if (entity != null) {
            List<OrgVO> result = this.orgMapper.queryParentsByOrgId(entity.getInnerCode());
            return result;
        }
        return null;
    }
}

