/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.UserEntity;
import com.ejianc.foundation.oms.mapper.UserMapper;
import com.ejianc.foundation.oms.pub.PasswordUtils;
import com.ejianc.foundation.oms.service.IPasswordPolicyService;
import com.ejianc.foundation.oms.service.IUserService;
import com.ejianc.foundation.oms.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends BaseServiceImpl<UserMapper, UserEntity>
implements IUserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IPasswordPolicyService passwordPolicyService;

    @Override
    public UserVO selectById(Long userId) {
        UserEntity entity = this.getById(userId);
        UserVO userVo = (UserVO)((Object)BeanMapper.map((Object)((Object)entity), UserVO.class));
        return userVo;
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        this.userMapper.updateUserPassword(userId, password);
    }

    @Override
    public UserVO queryLoginUserByUserCodeOrPhoneNumOrEMail(String condition) {
        UserVO userVo = null;
        QueryWrapper userCodeWrapper = new QueryWrapper();
        ((QueryWrapper)userCodeWrapper.eq((Object)"user_code", (Object)condition)).eq((Object)"dr", (Object)0);
        UserEntity userEntity = (UserEntity)((Object)this.getOne((Wrapper)userCodeWrapper));
        if (userEntity != null) {
            userVo = (UserVO)((Object)BeanMapper.map((Object)((Object)userEntity), UserVO.class));
            return userVo;
        }
        QueryWrapper userPhoneWrapper = new QueryWrapper();
        ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)condition)).eq((Object)"dr", (Object)0);
        userEntity = (UserEntity)((Object)this.getOne((Wrapper)userPhoneWrapper));
        if (userEntity != null) {
            userVo = (UserVO)((Object)BeanMapper.map((Object)((Object)userEntity), UserVO.class));
            return userVo;
        }
        QueryWrapper emailWrapper = new QueryWrapper();
        ((QueryWrapper)emailWrapper.eq((Object)"user_email", (Object)condition)).eq((Object)"dr", (Object)0);
        userEntity = (UserEntity)((Object)this.getOne((Wrapper)emailWrapper));
        if (userEntity != null) {
            userVo = (UserVO)((Object)BeanMapper.map((Object)((Object)userEntity), UserVO.class));
            return userVo;
        }
        return null;
    }

    @Override
    public void resetpwd(Long userId) {
        UserVO user = this.selectById(userId);
        if (null == user) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String password = this.passwordPolicyService.getUserDefaultPassword(InvocationInfoProxy.getTenantid());
        String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
        user.setPassword(shaPassword);
        user.setPassword(PasswordUtils.encodebyUserCode(user));
        user.setPwdStartTime(new Date());
        UserEntity saveEntity = (UserEntity)((Object)BeanMapper.map((Object)((Object)user), UserEntity.class));
        super.saveOrUpdate((Object)saveEntity);
    }

    @Override
    public UserEntity getById(Long userId) {
        return (UserEntity)((Object)super.getById((Serializable)userId));
    }

    private void userCheck(UserVO vo) {
        Pattern patternEmail;
        Matcher matcherEmail;
        Pattern patternMobile = Pattern.compile("^[1][34578][0-9]{9}$", 2);
        Matcher matcherMobile = patternMobile.matcher(vo.getUserMobile());
        if (!matcherMobile.matches()) {
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u624b\u673a\u975e\u6cd5");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getUserEmail()) && !(matcherEmail = (patternEmail = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$", 2)).matcher(vo.getUserEmail())).matches()) {
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u90ae\u7bb1\u975e\u6cd5");
        }
    }

    @Override
    public void updateUserState(Long userId, Integer state) {
        this.userMapper.updateUserState(userId, state);
    }

    @Override
    public List<UserEntity> selectAllByIds(List<Long> userIds) {
        return ((UserMapper)this.baseMapper).selectBatchIds(userIds);
    }
}

