/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialEntity;
import com.ejianc.business.op.service.IMaterialService;
import com.ejianc.business.op.vo.MaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"material"})
public class MaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialVO> saveOrUpdate(@RequestBody MaterialVO saveOrUpdateVO) {
        CommonResponse commonResponse = this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (commonResponse.isSuccess()) {
            List orgIdList = ((List)commonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ne(null != saveOrUpdateVO, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            queryWrapper.in(MaterialEntity::getOrgId, orgIdList);
            queryWrapper.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(MaterialEntity::getCode, (Object)saveOrUpdateVO.getCode())).or()).eq(MaterialEntity::getName, (Object)saveOrUpdateVO.getName()));
            if (this.materialService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u7f16\u7801\u6216\u540d\u79f0\u91cd\u590d\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u67e5\u8be2\u672c\u4e0a\u5931\u8d25");
        }
        MaterialEntity entity = (MaterialEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialEntity.class));
        if (null == entity.getOrgId()) {
            entity.setOrgId(InvocationInfoProxy.getOrgId());
        }
        this.materialService.saveOrUpdate((Object)entity, false);
        MaterialVO vo = (MaterialVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(Long id) {
        MaterialEntity entity = (MaterialEntity)((Object)this.materialService.selectById(id));
        MaterialVO vo = (MaterialVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialVO> vos) {
        this.materialService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse commonResponse = this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u67e5\u8be2\u672c\u4e0a\u5931\u8d25");
        }
        List orgIdList = ((List)commonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.materialService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/opMaterialRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> contractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!StringUtils.isNotBlank((CharSequence)condition)) return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId")) return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u4e2d\u7ec4\u7ec7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
        CommonResponse commonResponse = this.iOrgApi.findParentsByOrgId(orgId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u67e5\u8be2\u672c\u4e0a\u5931\u8d25");
        }
        List orgIdList = ((List)commonResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage pageData = this.materialService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }
}

