package com.ejianc.business.op.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 配置实体
 *
 * @author generator
 *
 */
 @TableName("ejc_op_config")
public class ConfigEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="qrcode")
    private String qrcode; // 二维码信息
    @TableField(value="org_id")
    private Long orgId; // 项目部组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="close_status")
    private Integer closeStatus; // 关闭状态0-未关闭 1-关闭
    @TableField(value="photo_status")
    private Integer photoStatus; // 确认时是否需要拍照0-否 1-是
    @TableField(value="guard_status")
    private Integer guardStatus; // 是否需要门岗确认
    @TableField(value="area_name")
    private String areaName; // 区域名称
    @TableField(value="enable")
    private Integer enable; // 启停用0-启用 1-停用
    @TableField(exist=false)
    @SubEntity(serviceName="configCheckerService" ,pidName = "pid")
    private List<ConfigCheckerEntity> checkerList = new ArrayList<>(); // 核验人员实体
    @TableField(exist=false)
    @SubEntity(serviceName="guardUserService" ,pidName = "pid")
    private List<GuardUserEntity> guardUserList = new ArrayList<>(); // 门岗人员实体
    @TableField(value="effective_time")
    private Integer effectiveTime; // 有效时间

    public Integer getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Integer effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<ConfigCheckerEntity> getCheckerList() {
        return checkerList;
    }

    public void setCheckerList(List<ConfigCheckerEntity> checkerList) {
        this.checkerList = checkerList;
    }

    public List<GuardUserEntity> getGuardUserList() {
        return guardUserList;
    }

    public void setGuardUserList(List<GuardUserEntity> guardUserList) {
        this.guardUserList = guardUserList;
    }

    public Integer getEnable() {
        return enable;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getQrcode() {
        return qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Integer getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Integer closeStatus) {
        this.closeStatus = closeStatus;
    }
    public Integer getPhotoStatus() {
        return photoStatus;
    }

    public void setPhotoStatus(Integer photoStatus) {
        this.photoStatus = photoStatus;
    }
    public Integer getGuardStatus() {
        return guardStatus;
    }

    public void setGuardStatus(Integer guardStatus) {
        this.guardStatus = guardStatus;
    }

}
