package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.enums.OutTypeEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("apply")
public class ApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IApplyService applyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVO) {
    	ApplyVO vo = applyService.insertOrUpdate(applyVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/getBaseInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> getBaseInfo(@RequestParam("orgId") String orgId, @RequestParam("openId") String openId) {
        ApplyVO applyVO = applyService.getBaseInfo(orgId, openId);
        return CommonResponse.success("获取默认信息成功！", applyVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyVO vo = applyService.selectDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 扫码后获取当前单据操作权限
     * @return
     */
    @RequestMapping(value = "/getPower", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getPower(@RequestParam("id") Long id, @RequestParam("openId") String openId) {
        return CommonResponse.success("扫码后获取当前单据操作权限成功", applyService.getPower(id, openId));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        applyService.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("applyUser");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
       // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter openIdParm = param.getParams().get("openId");
        if (null != openIdParm && null != openIdParm.getValue()) {
            param.getParams().put("openId", new Parameter(QueryParam.SQL, "open_id = '" + openIdParm.getValue() + "'"));
            logger.info("queryList params is " + JSONObject.toJSONString(param));
        } else {
            Parameter checkerOpenIdParm = param.getParams().get("checkerOpenId");
            if (checkerOpenIdParm != null) {
                param.getParams().put("checkerOpenId", new Parameter(QueryParam.EQ, checkerOpenIdParm.getValue()));

            } else {
                param.getParams().put("openId", new Parameter(QueryParam.SQL, "open_id = 'XXXX'"));
            }

        }

        IPage<ApplyEntity> page = applyService.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryReportList 查询台账列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyReportVO>> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("applyUser");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("branchCorpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织权限 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Page<ApplyReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ApplyReportVO> list = applyService.queryReportPage(page, wrapper);
        IPage<ApplyReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
//        JSONObject res = new JSONObject();
//        res.put("records", list);
//        res.put("total", page.getTotal());
//        res.put("current", page.getCurrent());
//        res.put("size", page.getSize());
//        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<ApplyReportVO>> res = this.queryReportList(param);
        List<ApplyReportVO> list = new ArrayList<>();
        if(res.getData() != null){
            list = res.getData().getRecords();
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                vo.setOpStatusName(OutTypeEnum.getEnumByCode(vo.getOpStatus()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("applyReportExport.xlsx", beans, response);
    }
}
