package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.service.IConfigCheckerService;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.vo.ConfigCheckerVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 核验人员实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("configChecker")
public class ConfigCheckerController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConfigCheckerService configCheckerService;
    @Autowired
    private IConfigService configService;
    private static final String PARAM_TIME = "P-4r63i892";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @RequestMapping(value = "/saveBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveBatch(@RequestBody List<ConfigCheckerVO> checkerVOS) {
        configCheckerService.saveBatch(checkerVOS);
    	return CommonResponse.success("保存单据成功！");
    }

    @RequestMapping(value = "/deleteById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deleteById(Long id) {
        configCheckerService.removeById(id, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConfigCheckerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));

        IPage<ConfigCheckerEntity> page = configCheckerService.queryPage(param,false);
        IPage<ConfigCheckerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfigCheckerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryCheckerByProj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryCheckerByProj(@RequestParam("orgId") Long orgId) {
        LambdaQueryWrapper<ConfigCheckerEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigCheckerEntity::getOrgId, orgId);
        List<ConfigCheckerEntity> checkerEntities = configCheckerService.list(queryWrapper);
        HashMap map = new HashMap();
        Integer time = 30;
        String nameStr = null;
        if(CollectionUtils.isNotEmpty(checkerEntities)){
            List<String> nameList = checkerEntities.stream().map(ConfigCheckerEntity::getName).collect(Collectors.toList());
            nameStr = StringUtils.join(nameList, ",");
        }
        LambdaQueryWrapper<ConfigEntity> cqw = new LambdaQueryWrapper<>();
        cqw.eq(ConfigEntity::getOrgId, orgId);
        cqw.eq(ConfigEntity::getDr, BaseVO.DR_UNDELETE);
        ConfigEntity configEntity = configService.getOne(cqw);
        if (null!=configEntity && null!=configEntity.getEffectiveTime()){
            time= configEntity.getEffectiveTime();
        }
        map.put("name",nameStr);
        map.put("time",time);
        return CommonResponse.success("查询项目下核验人员成功",  map);
    }

}
