package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.enums.OutTypeEnum;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.jfinal.template.stat.ast.If;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 配置实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("config")
public class ConfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConfigService configService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConfigVO> saveOrUpdate(@RequestBody ConfigVO saveOrUpdateVO) {
        ConfigEntity entity = BeanMapper.map(saveOrUpdateVO, ConfigEntity.class);
        if (null!=entity.getId()){
            entity = configService.selectById(entity.getId());
            entity.setAreaName(saveOrUpdateVO.getAreaName());
            entity.setOrgId(saveOrUpdateVO.getOrgId());
            entity.setOrgName(saveOrUpdateVO.getOrgName());
            entity.setEnable(saveOrUpdateVO.getEnable());
            entity.setEffectiveTime(saveOrUpdateVO.getEffectiveTime());
        }
        configService.saveOrUpdate(entity, false);
        ConfigVO vo = BeanMapper.map(entity, ConfigVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/createQRCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConfigVO> createQRCode(@RequestBody ConfigVO vo) {
        return CommonResponse.success("生成二维码成功", configService.createQRCode(vo));
    }
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfigVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ConfigVO vo : vos) {
            }
        }
        configService.removeByIds(vos.stream().map(ConfigVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConfigVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ConfigEntity> page = configService.queryPage(param,false);
        IPage<ConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfigVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetail(Long id) {
//        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(ConfigEntity::getOrgId, InvocationInfoProxy.getOrgId());
        ConfigEntity config = configService.selectById(id);
        if (null != config) {
            return CommonResponse.success("查询详情成功", BeanMapper.map(config, ConfigVO.class));
        }
        return CommonResponse.error("当前项目未做过出门证设置,请先生成二维码");
    }

    @RequestMapping(value = "/queryDetailByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetailByOrgId(@RequestParam(value = "orgId") String orgId) {
        //五局老数据传的orgId可能是NC项目主键
        CommonResponse<ProjectRegisterVO> response = projectApi.queryProjectBySourceId(orgId);
        ProjectRegisterVO projectRegisterVO = null;
        if (response.isSuccess() && null != response.getData() && null != response.getData().getId()) {
            projectRegisterVO = response.getData();
        } else {
            CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(orgId);
            projectRegisterVO = commonResponse.getData();
        }
        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigEntity::getOrgId, projectRegisterVO.getProjectDepartmentId());
        ConfigEntity config = configService.getOne(queryWrapper, false);
        if (null != config) {
            return CommonResponse.success("查询详情成功", BeanMapper.map(config, ConfigVO.class));
        }
        return CommonResponse.error("当前项目未做过出门证设置");
    }

    @RequestMapping(value = "/updateConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> close(@RequestBody ConfigVO configVO) {
        LambdaUpdateWrapper<ConfigEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(ConfigEntity::getOrgId, configVO.getOrgId());
        wrapper.set(null != configVO.getCloseStatus(), ConfigEntity::getCloseStatus, configVO.getCloseStatus());
        wrapper.set(null != configVO.getPhotoStatus(), ConfigEntity::getPhotoStatus, configVO.getPhotoStatus());
        wrapper.set(null != configVO.getGuardStatus(), ConfigEntity::getGuardStatus, configVO.getGuardStatus());
        configService.update(wrapper);
        return CommonResponse.success("更新成功");
    }

    @PostMapping("excelExport")
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConfigEntity> list = configService.queryList(param);
        List<ConfigVO> configList = BeanMapper.mapList(list, ConfigVO.class);
        for (ConfigVO configVO : configList) {
            configVO.setEnableName(configVO.getEnable()==0?"启用":"停用");
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", configList);
        ExcelExport.getInstance().export("config-export.xlsx", beans, response);
    }
}
