package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.vo.GuardUserVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 门岗人员实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("guardUser")
public class GuardUserController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConfigService configService;
    @Autowired
    private IGuardUserService guardUserService;
    private static final String PARAM_TIME = "P-4r63i892";
    @Autowired
    private IParamConfigApi paramConfigApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GuardUserVO> saveOrUpdate(@RequestBody GuardUserVO guardUserVO) {
    	return CommonResponse.success("保存或修改单据成功！", guardUserService.insertOrUpdate(guardUserVO));
    }

    @RequestMapping(value = "/updateClose", method = RequestMethod.GET)
    @ResponseBody
    public  CommonResponse<String> updateClose(@RequestParam("id") Long id, @RequestParam("closeStatus") Integer closeStatus) {
        GuardUserEntity guardUser = guardUserService.selectById(id);
        guardUser.setCloseStatus(closeStatus);
        guardUserService.updateById(guardUser);
        return CommonResponse.success("更新启用停用成功");
    }

    @RequestMapping(value = "/deleteById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deleteById(Long id) {
        guardUserService.removeById(id, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GuardUserVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));

        IPage<GuardUserEntity> page = guardUserService.queryPage(param,false);
        IPage<GuardUserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GuardUserVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/unBindWechat", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GuardUserVO> unBindWechat(Long id) {
        GuardUserEntity guardUserEntity = guardUserService.selectById(id);
        guardUserEntity.setBindStatus(0);
        guardUserEntity.setOpenId(null);
        guardUserService.updateById(guardUserEntity);
        return CommonResponse.success("门岗用户解绑成功", BeanMapper.map(guardUserEntity, GuardUserVO.class));
    }

    @RequestMapping(value = "/queryGuarderByProj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryGuarderByProj(@RequestParam("orgId") Long orgId) {
        LambdaQueryWrapper<GuardUserEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(GuardUserEntity::getCloseStatus, BooleanStatusEnum.否.getCode());
        queryWrapper.eq(GuardUserEntity::getOrgId, orgId);
        List<GuardUserEntity> guardUserEntities = guardUserService.list(queryWrapper);
        HashMap map = new HashMap();
        Integer time = 30;
        String nameStr = null;
        if(CollectionUtils.isNotEmpty(guardUserEntities)){
            List<String> nameList = guardUserEntities.stream().map(GuardUserEntity::getName).collect(Collectors.toList());
            nameStr = StringUtils.join(nameList, ",");
        }
        LambdaQueryWrapper<ConfigEntity> cqw = new LambdaQueryWrapper<>();
        cqw.eq(ConfigEntity::getOrgId, orgId);
        cqw.eq(ConfigEntity::getDr, BaseVO.DR_UNDELETE);
        ConfigEntity configEntity = configService.getOne(cqw);
        if (null!=configEntity && null!=configEntity.getEffectiveTime()){
            time= configEntity.getEffectiveTime();
        }
        map.put("name",nameStr);
        map.put("time",time);
        return CommonResponse.success("查询项目下门岗人员成功",  map);
    }
}
