package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialEntity;
import com.ejianc.business.op.bean.MaterialSpecEntity;
import com.ejianc.business.op.service.IMaterialService;
import com.ejianc.business.op.service.IMaterialSpecService;
import com.ejianc.business.op.vo.MaterialSpecVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资规格实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialSpec")
public class MaterialSpecController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialSpecService materialSpecService;
    @Autowired
    private IMaterialService materialService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialSpecVO> saveOrUpdate(@RequestBody MaterialSpecVO saveOrUpdateVO) {
        LambdaQueryWrapper<MaterialSpecEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialSpecEntity::getOpMaterialId, saveOrUpdateVO.getOpMaterialId());
        queryWrapper.eq(MaterialSpecEntity::getName, saveOrUpdateVO.getName());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MaterialSpecEntity::getId, saveOrUpdateVO.getId());
        if(materialSpecService.count(queryWrapper) > 0){
            throw new BusinessException("同一分类下规格型号重复！");
        }
        MaterialSpecEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialSpecEntity.class);
        materialSpecService.saveOrUpdate(entity, false);
        MaterialSpecVO vo = BeanMapper.map(entity,  MaterialSpecVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialSpecVO> queryDetail(Long id) {
    	 MaterialSpecEntity entity = materialSpecService.selectById(id);
    	 MaterialSpecVO vo = BeanMapper.map(entity,  MaterialSpecVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialSpecVO> vos) {
        materialSpecService.removeByIds(vos.stream().map(MaterialSpecVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialSpecVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null;
        Parameter idParam = param.getParams().get("opMaterialId");
        if (null != idParam && null != idParam.getValue()) {
            Long opMaterialId = Long.valueOf((String) idParam.getValue());
            MaterialEntity entity = materialService.getById(opMaterialId);
            orgId = entity.getOrgId();
        }

        IPage< MaterialSpecEntity> page = materialSpecService.queryPage(param,false);
        IPage< MaterialSpecVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialSpecVO> materialSpecVOS = BeanMapper.mapList(page.getRecords(), MaterialSpecVO.class);
        for (MaterialSpecVO specVO : materialSpecVOS) {
            specVO.setOrgId(orgId);
        }
        pageData.setRecords(materialSpecVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/opMaterialSpecRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialSpecVO>> contractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
//        if(StringUtils.isNotBlank(condition)) {
//            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
//            if(null != conditionMap.get("opMaterialId")) {
//                Long opMaterialId = Long.valueOf(conditionMap.get("opMaterialId").toString());
//                queryParam.getParams().put("opMaterialId", new Parameter(QueryParam.EQ, opMaterialId));
//            }else{
//                return CommonResponse.error("查询条件中物资主键不能为空");
//            }
//        }else{
//            return CommonResponse.error("查询条件不能为空");
//        }
        IPage<MaterialSpecEntity> pageData = materialSpecService.queryPage(queryParam,false);
        IPage<MaterialSpecVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), MaterialSpecVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }
}
