package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialEntity;
import com.ejianc.business.op.bean.MaterialUnitEntity;
import com.ejianc.business.op.service.IMaterialService;
import com.ejianc.business.op.service.IMaterialUnitService;
import com.ejianc.business.op.vo.MaterialUnitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资单位实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialUnit")
public class MaterialUnitController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialUnitService materialUnitService;
    @Autowired
    private IMaterialService materialService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialUnitVO> saveOrUpdate(@RequestBody MaterialUnitVO saveOrUpdateVO) {
        LambdaQueryWrapper<MaterialUnitEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialUnitEntity::getOpMaterialId, saveOrUpdateVO.getOpMaterialId());
        queryWrapper.eq(MaterialUnitEntity::getName, saveOrUpdateVO.getName());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MaterialUnitEntity::getId, saveOrUpdateVO.getId());
        if(materialUnitService.count(queryWrapper) > 0){
            throw new BusinessException("同一分类下单位重复！");
        }
    	MaterialUnitEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialUnitEntity.class);
        materialUnitService.saveOrUpdate(entity, false);
    	MaterialUnitVO vo = BeanMapper.map(entity, MaterialUnitVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialUnitVO> queryDetail(Long id) {
    	MaterialUnitEntity entity = materialUnitService.selectById(id);
    	MaterialUnitVO vo = BeanMapper.map(entity, MaterialUnitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialUnitVO> vos) {
        materialUnitService.removeByIds(vos.stream().map(MaterialUnitVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialUnitVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null;
        Parameter idParam = param.getParams().get("opMaterialId");
        if (null != idParam && null != idParam.getValue()) {
            Long opMaterialId = Long.valueOf((String) idParam.getValue());
            MaterialEntity entity = materialService.getById(opMaterialId);
            orgId = entity.getOrgId();
        }

        IPage<MaterialUnitEntity> page = materialUnitService.queryPage(param,false);
        IPage<MaterialUnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialUnitVO> unitVOList = BeanMapper.mapList(page.getRecords(), MaterialUnitVO.class);
        for (MaterialUnitVO unitVO : unitVOList) {
            unitVO.setOrgId(orgId);
        }
        pageData.setRecords(unitVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/opMaterialUnitRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialUnitVO>> contractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
//        if(StringUtils.isNotBlank(condition)) {
//            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
//            if(null != conditionMap.get("opMaterialId")) {
//                Long opMaterialId = Long.valueOf(conditionMap.get("opMaterialId").toString());
//                queryParam.getParams().put("opMaterialId", new Parameter(QueryParam.EQ, opMaterialId));
//            }else{
//                return CommonResponse.error("查询条件中物资主键不能为空");
//            }
//        }else{
//            return CommonResponse.error("查询条件不能为空");
//        }
        IPage<MaterialUnitEntity> pageData = materialUnitService.queryPage(queryParam,false);
        IPage<MaterialUnitVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), MaterialUnitVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

}
