package com.ejianc.business.op.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.vo.ConfigCheckerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.op.mapper.ConfigCheckerMapper;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.service.IConfigCheckerService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 核验人员实体
 *
 * @author generator
 *
 */
@Service("configCheckerService")
public class ConfigCheckerServiceImpl extends BaseServiceImpl<ConfigCheckerMapper, ConfigCheckerEntity> implements IConfigCheckerService{

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IConfigService configService;
    @Override
    public void saveBatch(List<ConfigCheckerVO> checkerVOS) {
        List<Long> useIdList = checkerVOS.stream().map(ConfigCheckerVO::getUserId).collect(Collectors.toList());
        Long pid = checkerVOS.get(0).getPid();
        ConfigEntity configEntity = configService.selectById(pid);
        LambdaQueryWrapper<ConfigCheckerEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigCheckerEntity::getPid, pid);
        queryWrapper.in(ConfigCheckerEntity::getUserId, useIdList);
        if (count(queryWrapper) > 0) {
            throw new BusinessException("所选用户已添加过改项目");
        }

        //CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(String.valueOf(InvocationInfoProxy.getOrgId()));
        for(ConfigCheckerVO configCheckerVO : checkerVOS){
            configCheckerVO.setOrgId(configEntity.getOrgId());
            //configCheckerVO.setProjectId(commonResponse.getData().getId());
        }

        saveOrUpdateBatch(BeanMapper.mapList(checkerVOS, ConfigCheckerEntity.class));
    }
}
