package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.mapper.ConfigMapper;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 配置实体
 *
 * @author generator
 *
 */
@Service("configService")
public class ConfigServiceImpl extends BaseServiceImpl<ConfigMapper, ConfigEntity> implements IConfigService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProjectApi projectApi;

    @Value("${oms.fileServerPath}")
    private String fileServerPath;

    @Override
    public ConfigVO createQRCode(ConfigVO vo) {
        //CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(String.valueOf(orgId));
        String accessroken =  null;
        if(null == redisTemplate.opsForValue().get("op_access_token")){
            accessroken = weChatUtil.getAccesstoken();
            if(!StringUtils.isEmpty(accessroken)){
                redisTemplate.opsForValue().set("op_access_token", accessroken, 90, TimeUnit.MINUTES);
            }
            logger.info("获取accessroken:"+accessroken);
        }else{
            accessroken = redisTemplate.opsForValue().get("op_access_token").toString();
            logger.info("获取accessroken:=====" + accessroken);
        }
        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigEntity::getOrgId, vo.getOrgId());
        queryWrapper.eq(ConfigEntity::getDr, BaseVO.DR_UNDELETE);
        int count = super.count(queryWrapper);
        if (count>0){
            throw new BusinessException("该组织已生成二维码，生成二维码失败！");
        }
        ConfigEntity config = new ConfigEntity();
        config.setId(IdWorker.getId());
        //config.setProjectId(commonResponse.getData().getId());
        config.setOrgId(vo.getOrgId());
        config.setOrgName(vo.getOrgName());
        config.setAreaName(vo.getAreaName());
        config.setCloseStatus(BooleanStatusEnum.否.getCode());
        config.setGuardStatus(BooleanStatusEnum.是.getCode());
        config.setPhotoStatus(BooleanStatusEnum.是.getCode());
        config.setEnable(0);
        config.setEffectiveTime(vo.getEffectiveTime());
        String path = "pages/newcard/newcard?orgId=" + vo.getOrgId() + "&tenantId=" + InvocationInfoProxy.getTenantid().toString();
        String multipartFile =  weChatUtil.createLongQRCodeStr(path, String.valueOf(vo.getOrgId()), accessroken);
        config.setQrcode(fileServerPath + "/" + dealImg(multipartFile, config));
        saveOrUpdate(config, false);
        return BeanMapper.map(config, ConfigVO.class);
    }

    @Override
    public ConfigVO queryDetailByOrgId(Long orgId) {
        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigEntity::getOrgId, orgId);
        ConfigEntity configEntity = getOne(queryWrapper, false);
        return null != configEntity ? BeanMapper.map(configEntity, ConfigVO.class) : null;
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, ConfigEntity configEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("BT202505000002");
        attachmentVO.setSourceId(String.valueOf(configEntity.getId()));
        attachmentVO.setSourceType("BT202505000002");
        attachmentVO.setFileList(Arrays.asList(file));
        logger.info(JSON.toJSONString(attachmentVO));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
