package com.ejianc.business.op.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.mapper.GuardUserMapper;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.util.MD5Utils;
import com.ejianc.business.op.vo.GuardUserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 门岗人员实体
 *
 * @author generator
 *
 */
@Service("guardUserService")
public class GuardUserServiceImpl extends BaseServiceImpl<GuardUserMapper, GuardUserEntity> implements IGuardUserService{

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IConfigService configService;
    @Override
    public GuardUserVO insertOrUpdate(GuardUserVO guardUserVO) {
        if (null == guardUserVO.getId()) {
            guardUserVO.setBindStatus(BooleanStatusEnum.否.getCode());
            guardUserVO.setCloseStatus(BooleanStatusEnum.否.getCode());
        }
        Long pid = guardUserVO.getPid();
        ConfigEntity configEntity = configService.selectById(pid);
        GuardUserEntity guardUser = BeanMapper.map(guardUserVO, GuardUserEntity.class);
        guardUser.setPwd(MD5Utils.getStringMD5(guardUser.getPwd().trim()));
        guardUser.setOrgId(configEntity.getOrgId());
//        CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(String.valueOf(InvocationInfoProxy.getOrgId()));
//        guardUser.setProjectId(commonResponse.isSuccess() && null != commonResponse.getData() ? commonResponse.getData().getId() : null);
        LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(GuardUserEntity::getUserName, guardUserVO.getUserName());
        wrapper.eq(GuardUserEntity::getPid, pid);
        wrapper.ne(null != guardUserVO.getId(), GuardUserEntity::getId, guardUserVO.getId());
        if(count(wrapper) > 0){
            throw  new BusinessException("用户名重复");
        }else{
            saveOrUpdate(guardUser);
        }
        return BeanMapper.map(guardUser, GuardUserVO.class);
    }
}
