package com.ejianc.business.op.util;

import com.jfinal.weixin.sdk.utils.JsonUtils;

import java.io.Serializable;
import java.util.HashMap;

/**
 * 模板消息数据对象
 *
 * @author L.cm
 * #date 2014-11-10 下午3:32:30
 * #description 模板消息数据对象
 */
public class TemplateDatas implements Serializable {
    private static final long serialVersionUID = 8038149984818112449L;

    private String touser;
    private String template_id;
    /**
     * 模板跳转链接
     *
     * @see #page
     */
    private TemplateItemMin miniprogram;
    private String page;
    private String miniprogram_state;
    private TemplateItem data;

    public static TemplateDatas New() {
        return new TemplateDatas();
    }

    private TemplateDatas() {
    	this.miniprogram = new TemplateItemMin();
        this.data = new TemplateItem();
    }

    public String getTouser() {
        return touser;
    }

    public TemplateDatas setTouser(String touser) {
        this.touser = touser;
        return this;
    }

	public TemplateItemMin getMiniprogram() {
		return miniprogram;
	}

	public String getTemplate_id() {
        return template_id;
    }

    public TemplateDatas setTemplate_id(String template_id) {
        this.template_id = template_id;
        return this;
    }

    public String getPage() {
        return page;
    }

    public TemplateDatas setPage(String page) {
        this.page = page;
        return this;
    }

    public String getMiniprogram_state() {
        return miniprogram_state;
    }

    public TemplateDatas setMiniprogram_state(String miniprogram_state) {
        this.miniprogram_state = miniprogram_state;
        return this;
    }

    public TemplateItem getData() {
        return data;
    }
    public TemplateDatas addMin(String key, String value){
    	miniprogram.put(key, value);
        return this;
    }
    public TemplateDatas add(String key, String value, String color){
        data.put(key, new Item(value, color));
        return this;
    }

    public TemplateDatas add(String key, String value){
        data.put(key, new Item(value));
        return this;
    }

    /**
     * 直接转化成jsonString
     * @return {String}
     */
    public String build() {
        return JsonUtils.toJson(this);
    }

    public class TemplateItem extends HashMap<String, Item> {

        private static final long serialVersionUID = -3728490424738325020L;

        public TemplateItem() {}

        public TemplateItem(String key, Item item) {
            this.put(key, item);
        }
    }

    public class TemplateItemMin extends HashMap<String, String> {

        private static final long serialVersionUID = -3728490424738325020L;

        public TemplateItemMin() {}

        public TemplateItemMin(String key, String item) {
            this.put(key, item);
        }
    }
    public class Item {
        private Object value;
        private String color;

        public Object getValue() {
            return value;
        }
        public void setValue(Object value) {
            this.value = value;
        }
        public String getColor() {
            return color;
        }
        public void setColor(String color) {
            this.color = color;
        }

        public Item(Object value) {
            this(value, "#999");
        }
        public Item(Object value, String color) {
            this.value = value;
            this.color = color;
        }
    }
}
