package com.ejianc.business.op.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;


/**
 * 配置实体
 *
 * @author generator
 *
 */
public class ConfigVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String qrcode; // 二维码信息
    private Long orgId; // 项目部组织主键
    private Long projectId; // 项目主键
    private Integer closeStatus; // 关闭状态0-未关闭 1-关闭
    private Integer photoStatus; // 确认时是否需要拍照0-否 1-是
    private Integer guardStatus; // 是否需要门岗确认
    private String areaName; // 区域名称
    private Integer enable; // 启停用0-启用 1-停用
    private String enableName; // 启停用0-启用 1-停用
    private List<ConfigCheckerVO> checkerList = new ArrayList<>(); // 核验人员实体
    private List<GuardUserVO> guardUserList = new ArrayList<>(); // 门岗人员实体
    private String orgName; // 组织名称
    private Integer effectiveTime; // 有效时间

    public Integer getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Integer effectiveTime) {
        this.effectiveTime = effectiveTime;
    }
    public String getEnableName() {
        return enableName;
    }

    public void setEnableName(String enableName) {
        this.enableName = enableName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<ConfigCheckerVO> getCheckerList() {
        return checkerList;
    }

    public void setCheckerList(List<ConfigCheckerVO> checkerList) {
        this.checkerList = checkerList;
    }

    public List<GuardUserVO> getGuardUserList() {
        return guardUserList;
    }

    public void setGuardUserList(List<GuardUserVO> guardUserList) {
        this.guardUserList = guardUserList;
    }

    public Integer getEnable() {
        return enable;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getQrcode() {
        return qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Integer getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Integer closeStatus) {
        this.closeStatus = closeStatus;
    }
    public Integer getPhotoStatus() {
        return photoStatus;
    }

    public void setPhotoStatus(Integer photoStatus) {
        this.photoStatus = photoStatus;
    }
    public Integer getGuardStatus() {
        return guardStatus;
    }

    public void setGuardStatus(Integer guardStatus) {
        this.guardStatus = guardStatus;
    }

}
