/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config"})
public class ConfigController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConfigVO> saveOrUpdate(@RequestBody ConfigVO saveOrUpdateVO) {
        ConfigEntity entity = (ConfigEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ConfigEntity.class));
        if (null != entity.getId()) {
            entity = (ConfigEntity)((Object)this.configService.selectById(entity.getId()));
            entity.setAreaName(saveOrUpdateVO.getAreaName());
            entity.setOrgId(saveOrUpdateVO.getOrgId());
            entity.setOrgName(saveOrUpdateVO.getOrgName());
            entity.setEnable(saveOrUpdateVO.getEnable());
            entity.setEffectiveTime(saveOrUpdateVO.getEffectiveTime());
        }
        this.configService.saveOrUpdate((Object)entity, false);
        ConfigVO vo = (ConfigVO)((Object)BeanMapper.map((Object)((Object)entity), ConfigVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/createQRCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConfigVO> createQRCode(@RequestBody ConfigVO vo) {
        return CommonResponse.success((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u6210\u529f", (Object)((Object)this.configService.createQRCode(vo)));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfigVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConfigVO configVO : vos) {
            }
        }
        this.configService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConfigVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("areaName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.configService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConfigVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetail(Long id) {
        ConfigEntity config = (ConfigEntity)((Object)this.configService.selectById(id));
        if (null != config) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f", (Object)BeanMapper.map((Object)((Object)config), ConfigVO.class));
        }
        return CommonResponse.error((String)"\u5f53\u524d\u9879\u76ee\u672a\u505a\u8fc7\u51fa\u95e8\u8bc1\u8bbe\u7f6e,\u8bf7\u5148\u751f\u6210\u4e8c\u7ef4\u7801");
    }

    @RequestMapping(value={"/queryDetailByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetailByOrgId(@RequestParam(value="orgId") String orgId) {
        CommonResponse response = this.projectApi.queryProjectBySourceId(orgId);
        ProjectRegisterVO projectRegisterVO = null;
        if (response.isSuccess() && null != response.getData() && null != ((ProjectRegisterVO)response.getData()).getId()) {
            projectRegisterVO = (ProjectRegisterVO)response.getData();
        } else {
            CommonResponse commonResponse = this.projectApi.queryProjectByProjectDepartmentId(orgId);
            projectRegisterVO = (ProjectRegisterVO)commonResponse.getData();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigEntity::getOrgId, (Object)projectRegisterVO.getProjectDepartmentId());
        ConfigEntity config = (ConfigEntity)((Object)this.configService.getOne((Wrapper)queryWrapper, false));
        if (null != config) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f", (Object)BeanMapper.map((Object)((Object)config), ConfigVO.class));
        }
        return CommonResponse.error((String)"\u5f53\u524d\u9879\u76ee\u672a\u505a\u8fc7\u51fa\u95e8\u8bc1\u8bbe\u7f6e");
    }

    @RequestMapping(value={"/updateConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> close(@RequestBody ConfigVO configVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ConfigEntity::getOrgId, (Object)configVO.getOrgId());
        wrapper.set(null != configVO.getCloseStatus(), ConfigEntity::getCloseStatus, (Object)configVO.getCloseStatus());
        wrapper.set(null != configVO.getPhotoStatus(), ConfigEntity::getPhotoStatus, (Object)configVO.getPhotoStatus());
        wrapper.set(null != configVO.getGuardStatus(), ConfigEntity::getGuardStatus, (Object)configVO.getGuardStatus());
        this.configService.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"excelExport"})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("areaName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.configService.queryList(param);
        List configList = BeanMapper.mapList((Iterable)list, ConfigVO.class);
        Iterator iterator = configList.iterator();
        while (iterator.hasNext()) {
            ConfigVO configVO;
            configVO.setEnableName((configVO = (ConfigVO)((Object)iterator.next())).getEnable() == 0 ? "\u542f\u7528" : "\u505c\u7528");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", configList);
        ExcelExport.getInstance().export("config-export.xlsx", beans, response);
    }
}

