/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.mapper.ConfigMapper;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="configService")
public class ConfigServiceImpl
extends BaseServiceImpl<ConfigMapper, ConfigEntity>
implements IConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectApi projectApi;
    @Value(value="${oms.fileServerPath}")
    private String fileServerPath;

    @Override
    public ConfigVO createQRCode(ConfigVO vo) {
        String accessroken = null;
        if (null == this.redisTemplate.opsForValue().get((Object)"op_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"op_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"op_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigEntity::getOrgId, (Object)vo.getOrgId());
        queryWrapper.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        int count = super.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u5df2\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\uff01");
        }
        ConfigEntity config = new ConfigEntity();
        config.setId(IdWorker.getId());
        config.setOrgId(vo.getOrgId());
        config.setOrgName(vo.getOrgName());
        config.setAreaName(vo.getAreaName());
        config.setCloseStatus(BooleanStatusEnum.\u5426.getCode());
        config.setGuardStatus(BooleanStatusEnum.\u662f.getCode());
        config.setPhotoStatus(BooleanStatusEnum.\u662f.getCode());
        config.setEnable(0);
        config.setEffectiveTime(vo.getEffectiveTime());
        String path = "pages/newcard/newcard?orgId=" + vo.getOrgId() + "&tenantId=" + InvocationInfoProxy.getTenantid().toString();
        String multipartFile = this.weChatUtil.createLongQRCodeStr(path, String.valueOf(vo.getOrgId()), accessroken);
        config.setQrcode(this.fileServerPath + "/" + this.dealImg(multipartFile, config));
        this.saveOrUpdate((Object)config, false);
        return (ConfigVO)((Object)BeanMapper.map((Object)((Object)config), ConfigVO.class));
    }

    @Override
    public ConfigVO queryDetailByOrgId(Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigEntity::getOrgId, (Object)orgId);
        ConfigEntity configEntity = (ConfigEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        return null != configEntity ? (ConfigVO)((Object)BeanMapper.map((Object)((Object)configEntity), ConfigVO.class)) : null;
    }

    private String dealImg(String file, ConfigEntity configEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("BT202505000002");
        attachmentVO.setSourceId(String.valueOf(configEntity.getId()));
        attachmentVO.setSourceType("BT202505000002");
        attachmentVO.setFileList(Arrays.asList(file));
        this.logger.info(JSON.toJSONString((Object)attachmentVO));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

