/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.order.bean.ChangeDetailEntity;
import com.ejianc.business.order.bean.ChangeEntity;
import com.ejianc.business.order.bean.ContractEntity;
import com.ejianc.business.order.enums.ChangeStatusEnum;
import com.ejianc.business.order.mapper.ChangeMapper;
import com.ejianc.business.order.service.IChangeDetailService;
import com.ejianc.business.order.service.IChangeService;
import com.ejianc.business.order.service.IContractService;
import com.ejianc.business.order.utils.TreeNodeBUtil;
import com.ejianc.business.order.vo.ChangeDetailVO;
import com.ejianc.business.order.vo.ChangeRecordDetailVO;
import com.ejianc.business.order.vo.ChangeRecordVO;
import com.ejianc.business.order.vo.ChangeVO;
import com.ejianc.business.order.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChangeServiceImpl")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    private static final String SUB_CHANGE_BILL_CODE = "SUB_CHANGE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IChangeDetailService changeDetailService;

    @Override
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        LambdaQueryWrapper queryWrapper;
        LambdaQueryWrapper lambda;
        if (this.checkFinishContract(changeVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        Object entity = null;
        Object entitiesc = null;
        List entities = null;
        int count = 0;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.ne(ChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)changeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_CHANGE_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (changeVO.getId() != null && changeVO.getId() > 0L && this.changeService.getById(changeVO.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(ChangeEntity::getContractId, (Object)changeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            queryWrapper.eq(ContractEntity::getBillCode, (Object)changeVO.getBillCode());
            queryWrapper.ne(BaseEntity::getId, (Object)changeVO.getContractId());
            count = this.contractService.count((Wrapper)queryWrapper);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.ne(ChangeEntity::getContractId, (Object)changeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            queryWrapper.eq(ContractEntity::getBillCode, (Object)changeVO.getBillCode());
            queryWrapper.ne(BaseEntity::getId, (Object)changeVO.getContractId());
            count = this.contractService.count((Wrapper)queryWrapper);
        }
        if (entities != null && entities.size() > 0 && count > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)changeVO, ChangeEntity.class));
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId() || CollectionUtils.isNotEmpty(beforeDetails) && this.changeService.getById(changeVO.getId()) == null) {
            for (ChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        List<ChangeDetailEntity> changeDetailEntities = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity cdEntity : changeDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ChangeDetailEntity cdEntity : changeDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.changeDetailService.saveOrUpdateBatch(changeDetailEntities, changeDetailEntities.size(), false);
        }
        this.saveWriteContract(changeEntity);
        return this.queryDetail(changeEntity.getId());
    }

    private Boolean checkSameBillCode(ChangeVO changeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getBillCode, (Object)changeVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != changeVO.getId() && changeVO.getId() > 0L) {
            lambda.ne(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        }
        Boolean changeCheckFlag = super.list((Wrapper)lambda).size() > 0;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVO.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)changeVO.getContractId()));
        Boolean contCheckFlag = this.contractService.queryList(queryParam, false).size() > 0;
        return changeCheckFlag != false || contCheckFlag != false;
    }

    private void saveWriteContract(ChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangingMny, (Object)changeEntity.getContractMny());
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)changeEntity.getContractTaxMny());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id));
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.changeDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (ChangeDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List list = BeanMapper.mapList((Iterable)detailEntityList, ChangeDetailVO.class);
        }
        changeVO.setChangeMny(ComputeUtil.safeSub((BigDecimal)changeVO.getContractTaxMny(), (BigDecimal)changeVO.getBeforeChangeTaxMny()));
        changeVO.setChangeMnyScale(ComputeUtil.bigDecimalPercent((BigDecimal)changeVO.getChangeMny(), (BigDecimal)changeVO.getBeforeChangeTaxMny(), (int)2));
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ChangeVO> vos) {
        ChangeVO changeVo = vos.get(0);
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        ContractEntity pcentity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        pcentity.setChangingMny(BigDecimal.ZERO);
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<ChangeVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List changeVOList = BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class);
        Page changeVOIPage = new Page();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)changeVOIPage);
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId) {
        List changeStageVOList;
        ContractVO contractVO = this.contractService.queryDetail(contractId, false);
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)contractVO, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractVO.getContractName());
        changeVO.setBeforeChangeMny(contractVO.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractVO.getContractTaxMny());
        changeVO.setContractId(changeVO.getId());
        changeVO.setChangeVersion(Integer.valueOf(contractVO.getChangeVersion() == null ? 1 : contractVO.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(Long.valueOf(IdWorker.getId()));
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcBid(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                changeDetailVO.setBeforeChangeMny(changeDetailVO.getMoney());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(null);
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        List changeClauseList = changeVO.getClauseList();
        if (CollectionUtils.isNotEmpty((Collection)changeClauseList)) {
            changeClauseList.forEach(changeClauseVO -> changeClauseVO.setRowState("add"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeStageVOList = changeVO.getStageList()))) {
            changeStageVOList.forEach(changeStageVO -> changeStageVO.setRowState("add"));
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "BT200529000000001", "subContractBill", String.valueOf(changeVO.getId()), "BT200610000000003", "subContractBill");
        return changeVO;
    }

    @Override
    public ChangeRecordVO queryDetailRecord(Long id) {
        BigDecimal sumChangeMny;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeRecordVO changeRecordVO = new ChangeRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        changeRecordVO.setContractId(id);
        changeRecordVO.setContractTaxMny(contractTaxMny);
        changeRecordVO.setBaseTaxMoney(baseTaxMny);
        changeRecordVO.setContractStatus(contractEntity.getContractStatus());
        changeRecordVO.setChangeStatus(contractEntity.getChangeStatus());
        changeRecordVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        BigDecimal bigDecimal = sumChangeMny = changeRecordVO.getSumChangeMny() == null ? BigDecimal.ZERO : changeRecordVO.getSumChangeMny();
        if (sumChangeMny.compareTo(BigDecimal.ZERO) != 0 && baseTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal sumScale = sumChangeMny.divide(baseTaxMny, 8, 5).multiply(new BigDecimal(100));
            changeRecordVO.setSumScale(sumScale);
        }
        if (null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ChangeEntity::getContractId, (Object)id);
            lambda.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List entities = super.list((Wrapper)lambda);
            entities.forEach(changevo -> {
                if (changevo.getChangeVersion() < 10) {
                    changevo.setBillCode(changevo.getBillCode() + "-0" + changevo.getChangeVersion());
                } else {
                    changevo.setBillCode(changevo.getBillCode() + "-" + changevo.getChangeVersion());
                }
            });
            changeRecordVO.setDetailList(BeanMapper.mapList((Iterable)entities, ChangeRecordDetailVO.class));
        }
        return changeRecordVO;
    }

    private Boolean checkFinishContract(ChangeVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }
}

