/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.order.bean.RecordDetailEntity;
import com.ejianc.business.order.bean.RecordEntity;
import com.ejianc.business.order.enums.ChangeTypeEnum;
import com.ejianc.business.order.mapper.RecordMapper;
import com.ejianc.business.order.service.IRecordDetailService;
import com.ejianc.business.order.service.IRecordService;
import com.ejianc.business.order.utils.TreeNodeBUtil;
import com.ejianc.business.order.vo.ContractDetailVO;
import com.ejianc.business.order.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RecordServiceImpl")
public class RecordServiceImpl
extends BaseServiceImpl<RecordMapper, RecordEntity>
implements IRecordService {
    @Autowired
    IRecordDetailService recordDetailService;

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RecordEntity::getChangeId, (Object)id);
        RecordEntity contractEntity1 = (RecordEntity)((Object)super.getOne((Wrapper)lambda));
        RecordEntity contractEntity = (RecordEntity)((Object)super.selectById((Serializable)contractEntity1.getId()));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.recordDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (RecordDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getContractDetailId().toString());
                cdEntity.setId(cdEntity.getContractDetailId());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            if (detailHasChildren.booleanValue()) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        }
        return contractVO;
    }
}

