package com.ejianc.business.other.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他支出合同记录
 * 
 * @author generator
 * 
 */
public class OtherContractHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private Long projectId; // 项目
    private Long orgId; // 组织
    private String contractName; // 合同名称
    private String contractStatus; // 合同状态：1-未签订, 2-履约中，3-已封帐
    private String billCode; // 单据编号
    private Long customerId; // 甲方
    private String customerName; // 甲方名称
    private Long supplierId; // 供应商
    private String supplierName; // 供应商名称
    private String orgName; // 组织名称
    private String projectName; // 项目名称
    private java.math.BigDecimal taxRate; // 合同税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    private Long contractType; // 合同类型
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private java.math.BigDecimal baseMoney; // 初始版本金额
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private java.math.BigDecimal beforeChangeMny; // 变更前金额
    private java.math.BigDecimal changingTaxMny; // 变更中金额（含税）
    private java.math.BigDecimal changingMny; // 变更中金额
    private Integer changeVersion; // 变更版本
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer billState; // 单据状态
    private java.math.BigDecimal sumSettleTaxMny; // 累计结算金额（含税）
    private java.math.BigDecimal sumSettleMny; // 累计结算金额
    private java.math.BigDecimal sumInvoicingTaxMny; // 累计收票（含税）
    private java.math.BigDecimal sumInvoicingMny; // 累计收票
    private String changeReason; // 变更原因
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    private java.math.BigDecimal sumOffsetMny; // 累计冲抵金额
    private java.math.BigDecimal sumPayMny; // 累计付款金额
    private java.math.BigDecimal sumPrepayMny; // 累计预付款金额
    /**
     * 合同优惠前金额
     */
    private BigDecimal contractUndiscountMny;

    /**
     * 优惠金额
     */
    private BigDecimal discountMny;
    
    private List<OtherContractDetailHistoryVO> detailVos = new ArrayList<>(); // 其他支出合同清单记录
    private List<OtherContractPayPlanHistoryVO> payPlanVos = new ArrayList<>(); // 其他支出付款计划记录
    private List<OtherContractClauseHistoryVO> clauseVos = new ArrayList<>(); // 其他支出合同条款记录

    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    private Integer dependOnProject;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    private Integer purchaseMode;
    /**
     * 采购方式名称
     */
    private String purchaseModeName;

    /**
     * 定标结果单id
     */
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    private String enquiryPriceBillName;

    //联系人
    private String linkUser;
    //联系电话
    private String linkPhone;
    //合同内容
    private String contractContent;
    //户名
    private String accountName;
    // 账号
    private String accountNo;
    //开户行
    private String openBank;


    public String getLinkUser() {
        return linkUser;
    }

    public void setLinkUser(String linkUser) {
        this.linkUser = linkUser;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNo() {
        return accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public String getOpenBank() {
        return openBank;
    }

    public void setOpenBank(String openBank) {
        this.openBank = openBank;
    }

    @ReferSerialTransfer(referCode = "othprice-result")
    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    @ReferDeserialTransfer
    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(Integer purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 甲方
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public java.math.BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(java.math.BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public java.math.BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(java.math.BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public java.math.BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(java.math.BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public java.math.BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(java.math.BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public java.math.BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(java.math.BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public java.math.BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(java.math.BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 累计结算金额（含税）
     */
    public java.math.BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 累计结算金额（含税）
     */
    public void setSumSettleTaxMny(java.math.BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 累计结算金额
     */
    public java.math.BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    /**
     * 累计结算金额
     */
    public void setSumSettleMny(java.math.BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    /**
     * 累计收票（含税）
     */
    public java.math.BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计收票（含税）
     */
    public void setSumInvoicingTaxMny(java.math.BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计收票
     */
    public java.math.BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计收票
     */
    public void setSumInvoicingMny(java.math.BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public Integer getIsFinish() {
        return isFinish;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public List<OtherContractDetailHistoryVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherContractDetailHistoryVO> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherContractPayPlanHistoryVO> getPayPlanVos() {
        return payPlanVos;
    }

    public void setPayPlanVos(List<OtherContractPayPlanHistoryVO> payPlanVos) {
        this.payPlanVos = payPlanVos;
    }

    public List<OtherContractClauseHistoryVO> getClauseVos() {
        return clauseVos;
    }

    public void setClauseVos(List<OtherContractClauseHistoryVO> clauseVos) {
        this.clauseVos = clauseVos;
    }
}
