/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractClauseChangeEntity;
import com.ejianc.business.other.bean.OtherContractDetailChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherContractPayPlanChangeEntity;
import com.ejianc.business.other.mapper.OtherContractChangeMapper;
import com.ejianc.business.other.service.CommonBillCodeService;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractClauseChangeService;
import com.ejianc.business.other.service.IOtherContractDetailChangeService;
import com.ejianc.business.other.service.IOtherContractPayPlanChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherContractChangeVO;
import com.ejianc.business.other.vo.OtherContractDetailChangeVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractChangeService")
public class OtherContractChangeServiceImpl
extends BaseServiceImpl<OtherContractChangeMapper, OtherContractChangeEntity>
implements IOtherContractChangeService {
    private static final String BILL_CODE = "OTHER_CONTRACT";
    @Autowired
    private CommonBillCodeService commonBillCodeService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailChangeService detailChangeService;
    @Autowired
    private IOtherContractPayPlanChangeService payPlanChangeService;
    @Autowired
    private IOtherContractClauseChangeService clauseChangeService;

    @Override
    public CommonResponse<OtherContractChangeVO> saveOrUpdate(OtherContractChangeVO changeVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = (OtherContractChangeEntity)((Object)BeanMapper.map((Object)changeVo, OtherContractChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(Integer.valueOf(1));
            } else {
                changeVo.setChangeVersion(Integer.valueOf(changeVo.getChangeVersion() + 1));
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                String code = this.commonBillCodeService.getCodeByOrgId(changeVo.getOrgId(), BILL_CODE, (BaseVO)changeVo);
                changeVo.setBillCode(code);
            }
            entity = (OtherContractChangeEntity)((Object)BeanMapper.map((Object)changeVo, OtherContractChangeEntity.class));
            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)changeVo.getId());
            lambda.ne(OtherContractChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.ne(OtherContractChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)changeVo.getContractId()));
        List entitiesc = this.contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity);
        this.saveChildren(changeVo, entity.getId(), operateType);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)changeVo.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny, (Object)changeVo.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)2);
        updateWrapper.set(OtherContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public void deleteChange(List<OtherContractChangeVO> vos) {
        for (OtherContractChangeVO vo : vos) {
            OtherContractChangeEntity changeEntity = (OtherContractChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny, (Object)BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)1);
            } else {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)3);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
        }
    }

    private void saveChildren(OtherContractChangeVO changeVo, Long changeId, String operateType) {
        List detailVos = changeVo.getDetailVos();
        List payPlanVos = changeVo.getPayPlanVos();
        List clauseVos = changeVo.getClauseVos();
        List<BaseEntity> detailSave = new ArrayList();
        List<BaseEntity> payPlanSave = new ArrayList();
        List<BaseEntity> clauseSave = new ArrayList();
        ArrayList<Long> detailDel = new ArrayList<Long>();
        ArrayList<Long> payPlanDel = new ArrayList<Long>();
        ArrayList<Long> clauseDel = new ArrayList<Long>();
        if (operateType.equals("add")) {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    vo.setId(null);
                    vo.setChangeId(changeId);
                }
                detailSave = BeanMapper.mapList((Iterable)detailVos, OtherContractDetailChangeEntity.class);
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : payPlanVos) {
                    vo.setId(null);
                    vo.setChangeId(changeId);
                }
                payPlanSave = BeanMapper.mapList((Iterable)payPlanVos, OtherContractPayPlanChangeEntity.class);
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : clauseVos) {
                    vo.setId(null);
                    vo.setChangeId(changeId);
                }
                clauseSave = BeanMapper.mapList((Iterable)clauseVos, OtherContractClauseChangeEntity.class);
            }
        } else {
            BaseEntity map;
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    if ("del".equals(vo.getRowState())) {
                        detailDel.add(vo.getId());
                        continue;
                    }
                    if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        map = (OtherContractDetailChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractDetailChangeEntity.class));
                        detailSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(vo.getRowState())) continue;
                    map = (OtherContractDetailChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractDetailChangeEntity.class));
                    detailSave.add(map);
                }
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : payPlanVos) {
                    if ("del".equals(vo.getRowState())) {
                        payPlanDel.add(vo.getId());
                        continue;
                    }
                    if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        map = (OtherContractPayPlanChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractPayPlanChangeEntity.class));
                        payPlanSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(vo.getRowState())) continue;
                    map = (OtherContractPayPlanChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractPayPlanChangeEntity.class));
                    payPlanSave.add(map);
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : clauseVos) {
                    if ("del".equals(vo.getRowState())) {
                        clauseDel.add(vo.getId());
                        continue;
                    }
                    if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        map = (OtherContractClauseChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractClauseChangeEntity.class));
                        clauseSave.add(map);
                        continue;
                    }
                    if (!"edit".equals(vo.getRowState())) continue;
                    map = (OtherContractClauseChangeEntity)((Object)BeanMapper.map((Object)vo, OtherContractClauseChangeEntity.class));
                    clauseSave.add(map);
                }
            }
        }
        if (detailSave.size() > 0) {
            this.detailChangeService.saveOrUpdateBatch(detailSave);
        }
        if (payPlanSave.size() > 0) {
            this.payPlanChangeService.saveOrUpdateBatch(payPlanSave);
        }
        if (clauseSave.size() > 0) {
            this.clauseChangeService.saveOrUpdateBatch(clauseSave);
        }
        if (detailDel.size() > 0) {
            this.detailChangeService.removeByIds(detailDel);
        }
        if (payPlanDel.size() > 0) {
            this.payPlanChangeService.removeByIds(payPlanDel);
        }
        if (clauseDel.size() > 0) {
            this.clauseChangeService.removeByIds(clauseDel);
        }
    }

    @Override
    public OtherContractChangeVO queryDetail(Long id) {
        OtherContractChangeEntity entity = (OtherContractChangeEntity)((Object)super.selectById((Serializable)id));
        OtherContractChangeVO changeVo = (OtherContractChangeVO)BeanMapper.map((Object)((Object)entity), OtherContractChangeVO.class);
        return changeVo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        if (entity != null) {
            OtherContractVO contractVo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            return contractVo;
        }
        return null;
    }
}

