/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractDetailEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.SupplementDetailEntity;
import com.ejianc.business.other.bean.SupplementEntity;
import com.ejianc.business.other.service.IOtherContractDetailService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.ISupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplement")
public class SupplementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISupplementService supplementService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailService contractDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplementEntity supplementEntity = (SupplementEntity)((Object)this.supplementService.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(supplementEntity.getMainContractId()));
        contractEntity.setContractMny(MathUtil.safeAdd((BigDecimal)contractEntity.getContractMny(), (BigDecimal)supplementEntity.getContractMny()));
        contractEntity.setContractTaxMny(MathUtil.safeAdd((BigDecimal)contractEntity.getContractTaxMny(), (BigDecimal)supplementEntity.getContractTaxMny()));
        contractEntity.setTaxMny(MathUtil.safeSub((BigDecimal)contractEntity.getContractTaxMny(), (BigDecimal)contractEntity.getContractMny()));
        this.contractService.updateById((Object)contractEntity);
        this.dealDetailData(supplementEntity, contractEntity);
        return CommonResponse.success();
    }

    private void dealDetailData(SupplementEntity supplementEntity, OtherContractEntity contractEntity) {
        List<OtherContractDetailEntity> detailList = contractEntity.getDetailVos();
        if (CollectionUtils.isNotEmpty(supplementEntity.getDetailVos())) {
            for (SupplementDetailEntity detailEntity : supplementEntity.getDetailVos()) {
                OtherContractDetailEntity contractDetailEntity = (OtherContractDetailEntity)((Object)BeanMapper.map((Object)((Object)detailEntity), OtherContractDetailEntity.class));
                contractDetailEntity.setId(null);
                contractDetailEntity.setContractId(contractEntity.getId());
                contractDetailEntity.setSrcSupplementDetailId(detailEntity.getId());
                contractDetailEntity.setSrcSupplementFlag(1);
                contractDetailEntity.setSrcSupplementId(supplementEntity.getId());
                detailList.add(contractDetailEntity);
            }
            this.contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

