/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleOtherVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettleService")
public class OtherSettleServiceImpl
extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity>
implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    private static final String CHECK_PARAM_CODE = "P-NB2T3930";
    private static final String OTHER_SETTLE_BILL_CODE = "OTHER_SETTLE";
    private static final String OTHER_SETTLE_DETAIL_BILL_CODE = "OTHER_SETTLE_DETAIL";
    private static final String OTHER_SETTLE_OTHER_BILL_CODE = "OTHER_SETTLE_OTHER";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        OtherContractEntity otherContractEntity;
        int num;
        LambdaQueryWrapper lambdaQuery;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            operateType = "edit";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        } else {
            operateType = "add";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        }
        if ((otherContractEntity = (OtherContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))).getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b8c\u5de5\u7ed3\u7b97!");
        }
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
            operateType = "edit";
        } else {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
            operateType = "add";
        }
        List entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd((BigDecimal)entity.getSettleTaxMny(), (BigDecimal)entity.getSumSettleTaxMny()));
        entity.setRelationFlag(this.getRelationFlag(saveorUpdateVO));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)super.selectById((Serializable)id));
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        BigDecimal safeDiv = MathUtil.safeDiv((BigDecimal)contractEntity.getSumSettleTaxMny(), (BigDecimal)contractEntity.getContractTaxMny());
        vo.setSumSettleRate(MathUtil.safeMultiply((BigDecimal)safeDiv, (BigDecimal)new BigDecimal(100)));
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)id);
        lambdaQuery.in(OtherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdaQuery);
        vo.setSettleRecord(BeanMapper.mapList((Iterable)list, OtherSettleVO.class));
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumSettleMentTaxMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO) {
        String relationFlag = this.getRelationFlag(otherSettleVO);
        OtherSettleEntity entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)otherSettleVO, OtherSettleEntity.class));
        entity.setRelationFlag(relationFlag);
        super.saveOrUpdate((Object)entity, false);
        Integer billState = entity.getBillState();
        if (relationFlag.equals("1")) {
            if (billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                this.processCost(entity);
            } else {
                this.delCost(entity.getId());
            }
        } else {
            this.delCost(entity.getId());
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    public String getRelationFlag(OtherSettleVO otherSettleVO) {
        List detailVos = otherSettleVO.getDetailVos();
        List otherVos = otherSettleVO.getOtherVos();
        String relationFlag = "1";
        for (OtherSettleDetailVO detailVO : detailVos) {
            if (detailVO.getSubjectId() != null && detailVO.getSubjectId() > 0L && detailVO.getAccountingId() != null && detailVO.getAccountingId() > 0L) continue;
            relationFlag = "0";
        }
        for (OtherSettleOtherVO otherVO : otherVos) {
            if (otherVO.getOtherSubjectId() != null && otherVO.getOtherSubjectId() > 0L && otherVO.getOtherAccountingId() != null && otherVO.getOtherAccountingId() > 0L) continue;
            relationFlag = "0";
        }
        return relationFlag;
    }

    @Override
    public void processCost(OtherSettleEntity entity) {
        CostDetailVO c;
        BaseEntity sub;
        int i;
        boolean canPush = true;
        ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
        if (ListUtil.isNotEmpty(entity.getDetailVos())) {
            for (i = 0; i < entity.getDetailVos().size(); ++i) {
                sub = entity.getDetailVos().get(i);
                if (sub.getSubjectId() == null || sub.getSubjectId() <= 0L || sub.getAccountingId() == null || sub.getAccountingId() <= 0L) {
                    canPush = false;
                    break;
                }
                c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setOrgSubjectId(sub.getOrgSubjectId());
                c.setAccountingId(sub.getAccountingId());
                c.setOrgAccountingId(sub.getOrgAccountingId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getDetailTaxMny() == null ? new BigDecimal("0.00") : sub.getDetailTaxMny());
                c.setHappenMny(sub.getDetailMny() == null ? new BigDecimal("0.00") : sub.getDetailMny());
                c.setHappenDate(entity.getSignDate());
                c.setMemo(sub.getDetailMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(OTHER_SETTLE_BILL_CODE);
                c.setSourceTabType(OTHER_SETTLE_DETAIL_BILL_CODE);
                list.add(c);
            }
        }
        if (ListUtil.isNotEmpty(entity.getOtherVos())) {
            for (i = 0; i < entity.getOtherVos().size(); ++i) {
                sub = entity.getOtherVos().get(i);
                if (sub.getOtherSubjectId() == null || sub.getOtherSubjectId() <= 0L || sub.getOtherAccountingId() == null || sub.getOtherAccountingId() <= 0L) {
                    canPush = false;
                    break;
                }
                c = new CostDetailVO();
                c.setSubjectId(sub.getOtherSubjectId());
                c.setOrgSubjectId(sub.getOtherSubjectId());
                c.setAccountingId(sub.getOtherAccountingId());
                c.setOrgAccountingId(sub.getOtherOrgAccountingId());
                c.setSourceDetailId(sub.getId());
                c.setSourceId(entity.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getOtherTaxMny() == null ? new BigDecimal("0.00") : sub.getOtherTaxMny());
                c.setHappenMny(sub.getOtherMny() == null ? new BigDecimal("0.00") : sub.getOtherMny());
                c.setHappenDate(entity.getSignDate());
                c.setMemo(sub.getOtherMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(OTHER_SETTLE_BILL_CODE);
                c.setSourceTabType(OTHER_SETTLE_OTHER_BILL_CODE);
                list.add(c);
            }
        }
        if (canPush) {
            CommonResponse response = this.iCostDetailApi.saveSubject(list);
            this.logger.info("\u63a8\u9001\u6210\u672c \u5176\u5b83\u652f\u51fa\u5408\u540c\u7ed3\u7b97 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
        } else {
            CommonResponse response = this.iCostDetailApi.deleteSubject(entity.getId());
            this.logger.info("\u5220\u9664\u6210\u672c \u5176\u5b83\u652f\u51fa\u5408\u540c\u7ed3\u7b97 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
        }
    }

    @Override
    public void delCost(Long id) {
        CommonResponse response = this.iCostDetailApi.deleteSubject(id);
        this.logger.info("\u5220\u9664\u6210\u672c \u5176\u5b83\u652f\u51fa\u5408\u540c\u7ed3\u7b97 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + id);
    }
}

