package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.CommonBillCodeService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT";

    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Autowired
    private IOtherSettleService settleService;

    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        String operateType = null;
        if (StringUtils.isEmpty(contractVo.getBillCode())) {
            String code = commonBillCodeService.getCodeByOrgId(contractVo.getOrgId(), BILL_CODE, contractVo);
            contractVo.setBillCode(code);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) { //修改

            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
            operateType = "edit";
        } else {
            //新增

            //新增设置 竣工结算标志
            contractVo.setIsFinish(0);
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
            operateType = "add";
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, contractVo.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        super.saveOrUpdate(entity, false);
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = super.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        List<OtherContractDetailVO> detailVos = vo.getDetailVos();
        List<OtherContractDetailVO> detail = new ArrayList<>();
        if (detailVos != null && detailVos.size() > 0) {
            for (OtherContractDetailVO dvo : detailVos) {
                if (dvo.getChangeType() == null || dvo.getChangeType() != 5) {
                    detail.add(dvo);
                }
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
    }

    @Override
    public List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthOtherMny(projectId, lastDay);
    }

    @Override
    public OtherProjectReportVo getOtherContract(Long projectId) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);

        // 合同数量 金额
        LambdaQueryWrapper<OtherContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractEntity::getProjectId, projectId);
        wrapper.eq(OtherContractEntity::getDr, 0);
        wrapper.eq(OtherContractEntity::getSupplementFlag, 0);
        wrapper.in(OtherContractEntity::getBillState, billStatus);
        List<OtherContractEntity> otherContractEntityList = super.list(wrapper);
        BigDecimal mny = otherContractEntityList.stream().filter(entity -> entity.getContractTaxMny() != null).map(OtherContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 结算金额
        LambdaQueryWrapper<OtherSettleEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(OtherSettleEntity::getProjectId, projectId);
        wrapper2.eq(OtherSettleEntity::getDr, 0);
        wrapper2.in(OtherSettleEntity::getBillState, billStatus);
        List<OtherSettleEntity> settlementEntityList = settleService.list(wrapper2);
        BigDecimal settleMny = settlementEntityList.stream().filter(entity -> entity.getSettleTaxMny() != null).map(OtherSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        OtherProjectReportVo vo = new OtherProjectReportVo();
        vo.setMny(mny);
        vo.setNum(otherContractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }

}
