package com.ejianc.business.other.service.impl;

import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractDetailEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.SupplementDetailEntity;
import com.ejianc.business.other.bean.SupplementEntity;
import com.ejianc.business.other.service.IOtherContractDetailService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.ISupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("supplement") 
public class SupplementBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISupplementService supplementService;

	@Autowired
	private IOtherContractService contractService;

	@Autowired
	private IOtherContractDetailService contractDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplementEntity supplementEntity = supplementService.selectById(billId);
		OtherContractEntity contractEntity  = contractService.selectById(supplementEntity.getMainContractId());
		contractEntity.setContractMny(MathUtil.safeAdd(contractEntity.getContractMny(), supplementEntity.getContractMny()));
		contractEntity.setContractTaxMny(MathUtil.safeAdd(contractEntity.getContractTaxMny(), supplementEntity.getContractTaxMny()));
		contractEntity.setTaxMny(MathUtil.safeSub(contractEntity.getContractTaxMny(), contractEntity.getContractMny()));
		contractService.updateById(contractEntity);

		dealDetailData(supplementEntity, contractEntity);

		return CommonResponse.success();
	}
	private void dealDetailData(SupplementEntity supplementEntity, OtherContractEntity contractEntity){
		List<OtherContractDetailEntity> detailList = contractEntity.getDetailVos();
		if(CollectionUtils.isNotEmpty(supplementEntity.getDetailVos())){
			for(SupplementDetailEntity detailEntity : supplementEntity.getDetailVos()){
				OtherContractDetailEntity contractDetailEntity = BeanMapper.map(detailEntity, OtherContractDetailEntity.class);
				contractDetailEntity.setId(null);
				contractDetailEntity.setContractId(contractEntity.getId());
				contractDetailEntity.setSrcSupplementDetailId(detailEntity.getId());
				contractDetailEntity.setSrcSupplementFlag(1);
				contractDetailEntity.setSrcSupplementId(supplementEntity.getId());
				detailList.add(contractDetailEntity);
			}
			contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("补充协议暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
