package com.ejianc.business.other.mapper;

import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.SqlParam;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.other.bean.OtherContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 其他支出合同实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface OtherContractMapper extends BaseCrudMapper<OtherContractEntity> {

    List<OtherProjectReportVo> getMonthOtherMny(@Param(value = "projectId")Long projectId, @Param(value = "lastDay") Integer lastDay);

    List<Map<String, Object>> queryPrePayWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryTaxWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryPayWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> querySettleWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    @Select("select count(id) from `ejc-cost`.`ejc_cost_closing_forecast` where dr = '0' and project_id = #{projectId} and bill_state != '3'")
	Integer countClosing(@Param(value = "projectId")Long projectId);

    @Select("select count(id) from `ejc-cost`.`ejc_cost_fin_cost_summary_reporting` where dr = '0' and project_id = #{projectId}")
	Integer state3count(@Param(value = "projectId")Long projectId);

    @Select("select IFNULL(subject_amount,0) from ejc_other_contract where contract_id = #{contractId}")
	BigDecimal queryForecast(@Param(value = "contractId")Long contractId);

//	OtherContractVO querySubject(Long projectId, Long subjectId);

}
