/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/other/"})
public class OtherContractApi {
    @Autowired
    private IOtherContractService otherContractService;
    @Autowired
    private IOtherSettleService otherSettleService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ICustomerApi customerApi;

    @GetMapping(value={"/getOtherContractById"})
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam(value="contractId") Long contractId) {
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)this.otherContractService.selectById(contractId));
        ContractResVO otherContractVO = (ContractResVO)BeanMapper.map((Object)((Object)otherContractEntity), ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse supplierVOCommonResponse = this.supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(((SupplierVO)supplierVOCommonResponse.getData()).getSocialCreditCode());
            }
            CommonResponse customerVOCommonResponse = this.customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(((CustomerVO)customerVOCommonResponse.getData()).getSocialCreditCode());
            }
        } else {
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6210\u529f", (Object)otherContractVO);
    }

    @RequestMapping(value={"/getMonthOtherMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="lastDay") Integer lastDay) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f", this.otherContractService.getMonthOtherMny(projectId, lastDay));
    }

    @GetMapping(value={"getOtherContract"})
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getOtherContract(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f", (Object)this.otherContractService.getOtherContract(projectId));
    }

    @GetMapping(value={"updateOtherContractSumPayMny"})
    public CommonResponse<String> updateOtherContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="prepayMny") BigDecimal prepayMny) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.otherContractService.selectById(contractId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5176\u5b83\u652f\u51fa\u5408\u540c\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
        entity.setSumPayMny(sumPayMny);
        BigDecimal sumPrepayMny = entity.getSumPrepayMny();
        sumPrepayMny = MathUtil.safeAdd((BigDecimal)sumPrepayMny, (BigDecimal)prepayMny);
        entity.setSumPrepayMny(sumPrepayMny);
        this.otherContractService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5176\u5b83\u652f\u51fa\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u3001\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateOtherSettleSumPayMny"})
    public CommonResponse<String> updateOtherSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="payMny") BigDecimal payMny) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.otherSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5176\u5b83\u652f\u51fa\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
        entity.setSumPayMny(sumPayMny);
        this.otherSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5176\u5b83\u652f\u51fa\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateOtherSettleSumApplyMny"})
    public CommonResponse<String> updateOtherSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="applyMny") BigDecimal applyMny) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.otherSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5176\u5b83\u652f\u51fa\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumApplyMny = entity.getSumApplyMny();
        sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)applyMny);
        entity.setSumApplyMny(sumApplyMny);
        BigDecimal surplusApplyMny = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)entity.getSettleTaxMny(), (BigDecimal)entity.getThisOffsetMny()), (BigDecimal)applyMny);
        entity.setSurplusApplyMny(surplusApplyMny);
        this.otherSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5176\u5b83\u652f\u51fa\u7ed3\u7b97\u5355\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u3001\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"getOtherSettlementById"})
    public CommonResponse<OtherSettleVO> getOtherSettlementById(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId) {
        OtherSettleVO vo = new OtherSettleVO();
        vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, 4));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId, (Object)contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId, (Object)orgId);
        lambdachange.in(OtherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.otherSettleService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] sumOffsetMny = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                sumOffsetMny[0] = sumOffsetMny[0].add(e.getThisOffsetMny() == null ? BigDecimal.ZERO : e.getThisOffsetMny());
            });
            vo.setSumOffsetMny(sumOffsetMny[0]);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u4fe1\u606f\u6210\u529f", (Object)vo);
    }

    @PostMapping(value={"otherAfterApproveInvoiceReceive"})
    public CommonResponse<JSONObject> otherAfterApproveInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.otherContractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoicingMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(OtherContractEntity::getSumInvoicingMny, (Object)sumInvoiceMny.add(invoiceMny));
            updateWrapper.set(OtherContractEntity::getSumInvoicingTaxMny, (Object)sumInvoiceTaxMny.add(invoiceTaxMny));
            boolean flag = this.otherContractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @PostMapping(value={"otherAfterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> otherAfterRevocationInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.otherContractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoicingMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoicingTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(OtherContractEntity::getSumInvoicingMny, (Object)sumInvoiceMny.subtract(invoiceMny));
            updateWrapper.set(OtherContractEntity::getSumInvoicingTaxMny, (Object)sumInvoiceTaxMny.subtract(invoiceTaxMny));
            boolean flag = this.otherContractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @GetMapping(value={"budgetControlTotal"})
    public CommonResponse<BigDecimal> budgetControlTotal(@RequestParam(value="projectId", required=true) Long projectId) {
        OtherContractVO vo = new OtherContractVO();
        vo.setProjectId(projectId);
        BigDecimal bigDecimal = this.otherContractService.totalContractMny(vo);
        return CommonResponse.success((Object)bigDecimal);
    }
}

