package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.finance.api.IBudgetControlApi;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.vo.ParamsCheckDsVO;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOtherSettleService settleService;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IBudgetControlApi budgetControlApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private  IOtherContractChangeService changeService;


    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        if (StringUtils.isEmpty(contractVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                contractVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) { //修改
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
        } else {
            //新增设置 竣工结算标志
            contractVo.setIsFinish(0);
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
            entity.setIsSupplement("0");
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, contractVo.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        super.saveOrUpdate(entity, false);
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = super.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        List<OtherContractDetailVO> detailVos = vo.getDetailVos();
        List<OtherContractDetailVO> detail = new ArrayList<>();
        if (detailVos != null && detailVos.size() > 0) {
            for (OtherContractDetailVO dvo : detailVos) {
                if (dvo.getChangeType() == null || dvo.getChangeType() != 5) {
                    detail.add(dvo);
                }
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
    }

    @Override
    public List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthOtherMny(projectId, lastDay);
    }

    @Override
    public OtherProjectReportVo getOtherContract(Long projectId) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);

        // 合同数量 金额
        LambdaQueryWrapper<OtherContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractEntity::getProjectId, projectId);
        wrapper.eq(OtherContractEntity::getDr, 0);
        wrapper.eq(OtherContractEntity::getSupplementFlag, 0);
        wrapper.in(OtherContractEntity::getBillState, billStatus);
        List<OtherContractEntity> otherContractEntityList = super.list(wrapper);
        BigDecimal mny = otherContractEntityList.stream().filter(entity -> entity.getContractTaxMny() != null).map(OtherContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 结算金额
        LambdaQueryWrapper<OtherSettleEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(OtherSettleEntity::getProjectId, projectId);
        wrapper2.eq(OtherSettleEntity::getDr, 0);
        wrapper2.in(OtherSettleEntity::getBillState, billStatus);
        List<OtherSettleEntity> settlementEntityList = settleService.list(wrapper2);
        BigDecimal settleMny = settlementEntityList.stream().filter(entity -> entity.getSettleTaxMny() != null).map(OtherSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        OtherProjectReportVo vo = new OtherProjectReportVo();
        vo.setMny(mny);
        vo.setNum(otherContractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }

    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(OtherContractVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算间接费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算间接费总金额
            BigDecimal budgetTaxMny =  data.getIndirectionTaxMny()==null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());

            if (!response.isSuccess()) {
                throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();


            //其他合同总金额
            BigDecimal  totalContractMny= totalContractMny(vo);
            CommonResponse<BigDecimal> respPay = budgetControlApi.budgetControlTotal(vo.getProjectId());
            logger.info("统计费用报销、备用金报销、零星付款申请 金额:{}", JSONObject.toJSONString(respPay));
            if (!response.isSuccess()){
                throw new BusinessException("网络错误"+respPay.getMsg());
            }else {
                if (respPay.getData()!=null){
                    totalContractMny = totalContractMny.add(respPay.getData());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("其他费用:{} 间接费用:{}",JSONObject.toJSONString(totalContractMny),JSONObject.toJSONString(budgetTaxMnyResult));
                        // 【预算间接费总金额】控 【实际间接费总金额】
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                            paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际间接费总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 预算间接费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO,ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
    @Override
    public BigDecimal totalContractMny(OtherContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<OtherContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("project_Id", vo.getProjectId());
        contractQuery.ne("change_status",2);
        if (vo.getId()!=null){
            contractQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractEntity contractEntity = super.getOne(contractQuery);
        if(contractEntity!=null &&null != contractEntity.getContractTaxMny()&&!"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<OtherContractChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractChangeEntity changeEntity = changeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }
}
