package com.ejianc.business.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.vo.RentContractPayVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@RestController
@RequestMapping("otherContract")
public class OtherContractController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractApi payContractApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOtherContractService service;

    @Autowired
    private IOtherSettleService settleService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO saveorUpdateVO) {
        CommonResponse<OtherContractVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(Long id) {
        OtherContractVO vo = service.queryDetail(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(OtherContractVO::getId).collect(Collectors.toList());
            //删除后如果是定标新增的则更新定标的签订合同金额
            LambdaQueryWrapper<OtherContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(OtherContractEntity::getId, ids);
            queryWrapper.isNotNull(OtherContractEntity::getEnquiryPriceBillId);
            List<OtherContractEntity> contractEntities = service.list(queryWrapper);
            boolean b = service.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty(contractEntities)) {
                List<Long> enquiryPriceBillIds = contractEntities.stream().filter(t -> t.getEnquiryPriceBillId() != null).map(OtherContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(enquiryPriceBillIds)) {
                    service.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
                }
            }
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        // 集采合同过滤支持
        param.getComplexParams().add(getPageQueryParam(null));

        IPage<OtherContractEntity> pageData = service.queryPage(param, false);
        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！", page);


    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("depend_on_project", new Parameter(QueryParam.EQ, "0"));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        }
        return c1;
    }

    /**
     * 合同参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractVO>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "searchText", required = false) String searchText,
                                                           @RequestParam(value = "searchObject", required = false) String searchObject,
                                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        //竣工结算标志
//        queryParam.getParams().put("is_finish", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));
        queryParam.getParams().put("contractStatus", new Parameter("ne", "3"));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
//            if (null != conditionMap.get("isFinishFlag")) {
//                boolean flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString());
//                // isFinishFlag 是否根据竣工过滤
//                if (!flag) {
//                    queryParam.getParams().remove("is_finish");
//                }
//            }
            if (null != conditionMap.get("mobileLeave")) {
                /** 移动端 有组织id 逻辑同pc端，没组织id 查租户下所有集采 */
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getComplexParams().add(getPageQueryParam(orgId));
                }
                // 移动端付款申请，选择不属于项目，需要参照租户下所有集采合同
                if (null != conditionMap.get("dependOnProject")) {
                    Integer dependOnProject = Integer.valueOf(conditionMap.get("dependOnProject").toString());
                    queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, dependOnProject));
                }
                if (null != conditionMap.get("projectId")) {
                    /** 项目关联合同以及集采合同 */
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                    ComplexParam in = new ComplexParam();
                    in.setLogic(ComplexParam.AND);
                    ComplexParam p = new ComplexParam();
                    p.setLogic(ComplexParam.OR);
                    p.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                    ComplexParam t = new ComplexParam();
                    t.setLogic(ComplexParam.OR);
                    t.getParams().put("purchaseMode", new Parameter(QueryParam.EQ, 1));
                    in.getComplexParams().add(p);
                    in.getComplexParams().add(t);
                    queryParam.getComplexParams().add(in);
                } else {
                    queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                }
            }  else {
                if(null != conditionMap.get("type") && "pay".equals(conditionMap.get("type").toString())){
                    queryParam.getComplexParams().add(getComplexParamForPay(orgId));
                    //收票和付款可以参照 已封账
                    queryParam.getParams().remove("contractStatus");
                } else {
                    queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }
        }
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        //queryParam.getOrderMap().put("signDate","desc");
        queryParam.getOrderMap().put("createTime", "desc");
        IPage<OtherContractEntity> pageData = service.queryPage(queryParam, false);
        IPage<OtherContractVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class));
        return CommonResponse.success("查询列表数据成功！", result);
    }

    /**
     * 传入/登录组织本下自采合同 + 登录组织本上加本下集采合同
     * @param orgId     null默认登录组织
     * @return
     */
    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 传入/登录组织本下自采合同
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_mode", new Parameter(QueryParam.EQ, 2));
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        // 登录组织本上加本下集采合同
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if(!allOrgIds.isEmpty()){
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_mode", new Parameter(QueryParam.EQ, 1));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }


    /**
     * 获取当前登录组织本上加本下的所有组织ID的集合
     * @return
     */
    public List<Long> getOrgUpToDownList(){
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("查询组织本上加本下信息失败！");
        }
        List<Long> parentIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }


    /**
     * 合同状态修改
     *
     * @param contractVo
     * @return
     */
    @PostMapping("/changeState")
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody OtherContractVO contractVo) {
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherContractEntity::getId, contractVo.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, contractVo.getContractStatus());
        service.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherContractEntity> entityList = service.queryList(param);
        List<OtherContractVO> list = BeanMapper.mapList(entityList, OtherContractVO.class);
        //todo:字段翻译等等
        list.forEach(vo -> {
            if (null != vo.getContractStatus()) {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("未签订");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("履约中");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("已封账");
                }
            } else {
                vo.setContractStatusName("");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOtherContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractVO>> refOtherContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OtherContractEntity> page = service.queryPage(param, false);
        IPage<OtherContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherContractVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 根据主键ID查询收票记录详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryInvoiceDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        OtherContractEntity entity = service.selectById(id);
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        InvoiceReceiveRecordVO vo = res.getData();
        if(null!=vo){
            vo.setContractTaxMny(entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny());
            //获取累计结算
            BigDecimal sumSettlementTaxMny = entity.getSumSettleTaxMny()==null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
            BigDecimal settleNoRecMny = MathUtil.safeSub(sumSettlementTaxMny, vo.getInvoiceTaxMny());
            //已结算未收票金额
            vo.setSettleNoRecMny(settleNoRecMny);
            vo.setSumSettleTaxMny(sumSettlementTaxMny);
        }
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID查询付款记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryPayDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        OtherContractEntity entity = service.selectById(id);
        RentContractPayVO rentContractPayVO = BeanMapper.map(entity, RentContractPayVO.class);
        CommonResponse<SumPayMnyVO> sumPayMnyVOList = payContractApi.getSumPayMnyVOList(id, null);
        if(!sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("获取付款信息失败！");
        }
        BigDecimal sumPayMny = sumPayMnyVOList.getData().getSumPayMny()==null?BigDecimal.ZERO:sumPayMnyVOList.getData().getSumPayMny();
        BigDecimal sumDeductionMny = sumPayMnyVOList.getData().getSumDeductionMny();
        rentContractPayVO.setSumDeductionMny(sumDeductionMny);
        rentContractPayVO.setContractId(sumPayMnyVOList.getData().getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(sumPayMnyVOList.getData().getContractVOList());
        rentContractPayVO.setSumApplyMny(sumPayMnyVOList.getData().getSumApplyMny()==null?BigDecimal.ZERO: sumPayMnyVOList.getData().getSumApplyMny());

        //累计结算金额
        BigDecimal sumSettlementTaxMny = getTotalSettleAmount(id);

        rentContractPayVO.setSumSettlementTaxMny(sumSettlementTaxMny);
        //获取累计收票
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        rentContractPayVO.setSumInvoiceTaxMny(res.getData().getInvoiceTaxMny());

        //累计未付金额 = 累计结算金额 - 累计付款金额 - 累计扣款金额
        rentContractPayVO.setSumUnPayMny(ComputeUtil.safeSub(sumSettlementTaxMny, sumPayMny, sumDeductionMny));
        boolean freeFlag = false;
        //查询是否存在预付款
        for (PayContractVO vo :sumPayMnyVOList.getData().getContractVOList()) {
            if (vo.getFeeType()==1){
                freeFlag = true;
                break;
            }
        }
        if (!freeFlag){
            QueryWrapper<OtherSettleEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.select("IFNULL(SUM(this_offset_mny),0) as thisOffsetMny");
            queryWrapper.eq("contract_id",id);
            queryWrapper.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            queryWrapper.in("org_id",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()) );
            OtherSettleEntity one = settleService.getOne(queryWrapper);
            rentContractPayVO.setSumUnPayMny(MathUtil.safeSub(rentContractPayVO.getSumUnPayMny(),one.getThisOffsetMny()));
        }

        return CommonResponse.success(rentContractPayVO);
    }
    private BigDecimal getTotalSettleAmount(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        OtherContractEntity contract = service.selectById(contractId);
        if (!MaterialContractVO.CONTRACT_BELONG_PROJECT.equals(contract.getDependOnProject())) {
            // 集采查询组织本下审批通过、已提交的结算
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询合同收票记录失败，获取组信息失败！");
            }
            List<Long> orgIds = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }

        return settleService.calculateTotalSettlement(queryParam);
    }
    /**
     * @Author yqls
     * @Date 2021/9/26 根据项目查询 其他合同金额 和其他合同结算金额 移动首页使用
     * @Description getOtherContractTotalAmount
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @PostMapping("getOtherContractTotalAmount")
    public CommonResponse<JSONObject> getOtherContractTotalAmount(@RequestBody Long orgId){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
//        if(ListUtil.isNotEmpty(projectIds)){
//            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
//        }
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<OtherSettleEntity> settlementEntities = settleService.queryList(queryParam);
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
        List<OtherContractEntity> list = service.queryList(queryParam);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(settlementEntities)){
            for (OtherSettleEntity c : settlementEntities) {
                if(c.getSettleTaxMny()!=null){
                    settle = MathUtil.safeAdd(settle, c.getSettleTaxMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(list)){
            for (OtherContractEntity c : list) {
                if(c.getContractTaxMny()!=null){
                    contract = MathUtil.safeAdd(contract, c.getContractTaxMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        back.put("contract",contract);
        back.put("settle",settle);
        return CommonResponse.success(back);
    }

    /**
     * 统计匹配条件的（属于项目的）合同含税现合同金额总值(单位：万元）
     *
     * @param param
     *      projectIds: 指定所属的项目的id列表
     * @return
     */
    @PostMapping(value = "analysisContract")
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        QueryParam queryParam = new QueryParam();
        //租户隔离
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
        queryParam.getParams().put("dr",new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        //审批生效的单据
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        if(null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>)param.get("projectIds"))) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, param.get("projectIds")));
        }
        Map<String, Object> result = service.countContractAmount(queryParam);
        String dataStr =  (null != result && null != result.get("curAmount")) ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);

        return CommonResponse.success(total.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
    }
    /**
     * 参数控制
     *
     * @param entity 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @PostMapping("checkParams")
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OtherContractVO entity) {
        return CommonResponse.success("参数校验成功！", service.checkParams(entity));
    }
}
