package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.bean.OtherSettleOtherEntity;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleDetailService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.*;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 结算
 *
 * @author generator
 */
@Service("otherSettleService")
public class OtherSettleServiceImpl extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity> implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    private static final String CHECK_PARAM_CODE = "P-NB2T3930";
    private static final String OTHER_SETTLE_BILL_CODE = "OTHER_SETTLE";
    private static final String OTHER_SETTLE_DETAIL_BILL_CODE = "OTHER_SETTLE_DETAIL";
    private static final String OTHER_SETTLE_OTHER_BILL_CODE = "OTHER_SETTLE_OTHER";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherSettleDetailService otherSettleDetailService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IInvoiceApi invoiceApi;



    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            operateType = "edit";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        } else {
            operateType = "add";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        }


        OtherContractEntity otherContractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if (otherContractEntity.getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("该合同已完工结算!");
        }
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "edit";
        } else {
            //新增
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "add";
        }

        List<OtherSettleEntity> entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            lambda.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            entities = super.list(lambda);
        } else {
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd(entity.getSettleTaxMny(), entity.getSumSettleTaxMny()));
        entity.setRelationFlag(getRelationFlag(saveorUpdateVO));

        //获取已收票金额
        CommonResponse<BigDecimal> invoiceReceiceMnyRes = invoiceApi.getInvoiceReceiceMny(entity.getContractId(), entity.getOrgId());
        if(invoiceReceiceMnyRes.isSuccess()){
            entity.setSumInvoiceTaxMny(ComputeUtil.nullToZero(invoiceReceiceMnyRes.getData()));
        }
        super.saveOrUpdate(entity, false);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = super.selectById(id);
        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = contractService.selectById(id);

        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractStatus(contractEntity.getContractStatus());
//        BigDecimal safeDiv = MathUtil.safeDiv(contractEntity.getSumSettleTaxMny(), contractEntity.getContractTaxMny());
//        vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, id);
        lambdaQuery.in(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        Long orgId = InvocationInfoProxy.getOrgId();
        //集采查询组织本下审批通过、已提交的结算
        if(!"1".equals(contractEntity.getDependOnProject())) {

            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
            if(orgResp.isSuccess()) {
                List<Long> orgIds = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                lambdaQuery.in(OtherSettleEntity::getOrgId, orgIds);
            }
        }
        else{
            lambdaQuery.eq(OtherSettleEntity::getOrgId, orgId);
        }
        lambdaQuery.orderByDesc(OtherSettleEntity::getCreateTime);
        List<OtherSettleEntity> list = super.list(lambdaQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal settleTaxMny = BigDecimal.ZERO;
            for (OtherSettleEntity otherSettleEntity : list) {
                settleTaxMny =  ComputeUtil.safeAdd(settleTaxMny,otherSettleEntity.getSettleTaxMny());
                BigDecimal ratio = ComputeUtil.safeDiv(otherSettleEntity.getSettleTaxMny(), contractEntity.getContractTaxMny());
                otherSettleEntity.setSumSettleRate(ComputeUtil.safeMultiply(ratio, new BigDecimal(100)));
            }
            BigDecimal safeDiv = MathUtil.safeDiv(settleTaxMny, contractEntity.getContractTaxMny());
            vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
            vo.setSumSettleTaxMny(settleTaxMny);
        }else {
            vo.setSumSettleRate(BigDecimal.ZERO);
            vo.setSumSettleTaxMny(BigDecimal.ZERO);
        }
        vo.setSettleRecord(BeanMapper.mapList(list, OtherSettleVO.class));
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType,Long orgId, BigDecimal settleTaxMny, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        logger.info("settleTaxMny:{},sumSettleMentTaxMny:{},contractTaxMny:{} ",
                JSONObject.toJSONString(settleTaxMny),
                JSONObject.toJSONString(sumSettleMentTaxMny),
                JSONObject.toJSONString(contractTaxMny)
        );
        CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (!response.isSuccess()) {
            logger.info(response.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> billParamVOS = response.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100)
                            , 2, BigDecimal.ROUND_HALF_UP));
                    if (1 == purchaseType) {
                        // 集采合同直接赋值为不控制
                        billParamVO.setControlType(0);
                    }
                    if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
//                        sumSettleMentTaxMny
                        stringBuffer.append("本次结算金额：").append(settleTaxMny.toString())
                                .append("元,含本期累计结算金额:").append(sumSettleMentTaxMny.toString())
                                .append("元，合同金额*").append(roleValue).append("%:")
                                .append(comMny).append("元。超出金额：")
                                .append(sumSettleMentTaxMny.subtract(comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);

                    }

                }}
        }

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
    @Override
    public CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO) {
        OtherSettleEntity entity = baseMapper.selectById(otherSettleVO.getId());

        if (ListUtil.isNotEmpty(otherSettleVO.getDetailVos())) {
            List<OtherSettleDetailEntity> purchaseSettleDetail = BeanMapper.mapList(otherSettleVO.getDetailVos(), OtherSettleDetailEntity.class);
            entity.setDetailVos(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty(otherSettleVO.getOtherVos())) {
            List<OtherSettleOtherEntity> purchaseSettleFee = BeanMapper.mapList(otherSettleVO.getOtherVos(), OtherSettleOtherEntity.class);
            entity.setOtherVos(purchaseSettleFee);
        }
        String relationFlag = getRelationFlag(otherSettleVO);
        entity.setRelationFlag(relationFlag);
        super.saveOrUpdate(entity, false);
        Integer billState = entity.getBillState();
        if (relationFlag.equals("1")) {
            if (billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                processCost(entity);
            } else {
                delCost(entity.getId());
            }
        } else {
            delCost(entity.getId());
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    public String getRelationFlag(OtherSettleVO otherSettleVO) {
        List<OtherSettleDetailVO> detailVos = otherSettleVO.getDetailVos();
        List<OtherSettleOtherVO> otherVos = otherSettleVO.getOtherVos();
        String relationFlag = "1";
        for (OtherSettleDetailVO detailVO : detailVos) {
            if (detailVO.getSubjectId() == null || detailVO.getSubjectId() <= 0) {
                relationFlag = "0";
            }
        }
        for (OtherSettleOtherVO otherVO : otherVos) {
            if (otherVO.getOtherSubjectId() == null || otherVO.getOtherSubjectId() <= 0) {
                relationFlag = "0";
            }
        }
        return relationFlag;
    }

    // 只推送
    @Override
    public void processCost(OtherSettleEntity entity) {
        boolean canPush = true;
        List<CostDetailVO> list = new ArrayList<>();
        if (ListUtil.isNotEmpty(entity.getDetailVos())) {
            for (int i = 0; i < entity.getDetailVos().size(); i++) {
                OtherSettleDetailEntity detail = entity.getDetailVos().get(i);
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setHappenTaxMny(detail.getDetailTaxMny() == null ? new BigDecimal("0.00") : detail.getDetailTaxMny());
                costDetailVO.setHappenMny(detail.getDetailMny() == null ? new BigDecimal("0.00") : detail.getDetailMny());
                costDetailVO.setHappenDate(entity.getSignDate());
                costDetailVO.setMemo(detail.getDetailMemo());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(OTHER_SETTLE_BILL_CODE);
                costDetailVO.setSourceTabType(OTHER_SETTLE_DETAIL_BILL_CODE);

                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSignDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("其他支出合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-other-frontend/#/otherSettle?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                costDetailVO.setNum(detail.getSettleNum() == null ? BigDecimal.ZERO : detail.getSettleNum()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量
                list.add(costDetailVO);

            }

        }
        if (ListUtil.isNotEmpty(entity.getOtherVos())) {
            for (int i = 0; i < entity.getOtherVos().size(); i++) {
                OtherSettleOtherEntity sub = entity.getOtherVos().get(i);
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(sub.getOtherSubjectId());
                costDetailVO.setSourceDetailId(sub.getId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setHappenTaxMny(sub.getOtherTaxMny() == null ? new BigDecimal("0.00") : sub.getOtherTaxMny());
                costDetailVO.setHappenMny(sub.getOtherMny() == null ? new BigDecimal("0.00") : sub.getOtherMny());
                costDetailVO.setHappenDate(entity.getSignDate());
                costDetailVO.setMemo(sub.getOtherMemo());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(OTHER_SETTLE_BILL_CODE);
                costDetailVO.setSourceTabType(OTHER_SETTLE_OTHER_BILL_CODE);
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSignDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("其他支出合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-other-frontend/#/otherSettle?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                list.add(costDetailVO);
            }

        }

        if (CollectionUtils.isEmpty(entity.getDetailVos()) && CollectionUtils.isEmpty(entity.getOtherVos())) {
            CostDetailVO costDetailVO = new CostDetailVO();
//            costDetailVO.setSubjectId(sub.getOtherSubjectId());
//            costDetailVO.setSourceDetailId(sub.getId());
            costDetailVO.setSourceId(entity.getId());
            costDetailVO.setProjectId(entity.getProjectId());
            costDetailVO.setHappenTaxMny(entity.getSettleTaxMny() == null ? new BigDecimal("0.00") : entity.getSettleTaxMny());
            costDetailVO.setHappenMny(entity.getSettleMny() == null ? new BigDecimal("0.00") : entity.getSettleMny());
            costDetailVO.setHappenDate(entity.getSignDate());
//            costDetailVO.setMemo(sub.getOtherMemo());
            costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(OTHER_SETTLE_BILL_CODE);
//            costDetailVO.setSourceTabType(OTHER_SETTLE_OTHER_BILL_CODE);
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
            LocalDate settlementDate = entity.getSignDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
            costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
            costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
            costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
            // c.setShareId(); // 归集单据id 说明：不用传
            costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
            costDetailVO.setSourceBillName("其他支出合同结算"); // 来源单据名称 说明：材料验收单
            costDetailVO.setSourceBillUrl("/ejc-other-frontend/#/otherSettle?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
            list.add(costDetailVO);
        }

        if (canPush) {
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            // entity.setRelationFlag("1");
        } else {
            CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            logger.info("删除成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            // entity.setRelationFlag("0");
        }
    }

    // 只删除
    @Override
    public void delCost(Long id) {
        CommonResponse<String> response = iCostDetailApi.deleteSubject(id);
        logger.info("删除成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + id);
    }

    @Override
    public List<OtherSettleDetailVO> settlementExcelDownload(OtherSettleVO vo) {
        List<OtherSettleDetailVO> list = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<OtherSettleEntity> entityList = this.queryList(queryParam, false);
        for (OtherSettleEntity rentSettlementEntity : entityList) {
            queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, rentSettlementEntity.getId()));
            List<OtherSettleDetailEntity> detailEntityList = otherSettleDetailService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                List<OtherSettleDetailVO> listTemp = BeanMapper.mapList(detailEntityList, OtherSettleDetailVO.class);
                for (int i = 0; i < listTemp.size(); i++) {
                    OtherSettleDetailVO otherSettleDetailVO = listTemp.get(i);
                    if ("1".equals(otherSettleDetailVO.getSourceType())) {
                        otherSettleDetailVO.setSourceTypeName("合同外");
                    } else if ("0".equals(otherSettleDetailVO.getSourceType())) {
                        otherSettleDetailVO.setSourceTypeName("合同内");
                    } else {
                        otherSettleDetailVO.setSourceTypeName(null);
                    }
                    otherSettleDetailVO.setSettlementCode(rentSettlementEntity.getBillCode());
                }
                list.addAll(listTemp);
            }
        }
        return list;
    }
    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<OtherSettleEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(settle_tax_mny) as totalSettleAmount");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }
}
