package com.ejianc.business.other.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.other.bean.OtherContractDetailEntity;
import com.ejianc.business.other.bean.OtherContractPayPlanEntity;
import com.ejianc.business.other.bean.OtherContractClauseEntity;
/**
 * 其他支出合同实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_other_contract")
public class OtherContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态：1-未签订, 2-履约中，3-已封帐
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="customer_id")
    private Long customerId; // 甲方
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contract_type_name")
    private String contractTypeName;
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 合同税率
    @TableField(value="sign_date")
    private java.util.Date signDate; // 签约日期
    @TableField(value="contract_type")
    private Long contractType; // 合同类型
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_tax_mny")
    private java.math.BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="base_tax_money")
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value="base_money")
    private java.math.BigDecimal baseMoney; // 初始版本金额
    @TableField(value="before_change_tax_mny")
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="before_change_mny")
    private java.math.BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="changing_tax_mny")
    private java.math.BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="changing_mny")
    private java.math.BigDecimal changingMny; // 变更中金额
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    /**
     * 合同优惠前金额
     */
    @TableField(value = "contract_undiscount_mny")
    private BigDecimal contractUndiscountMny;

    /**
     * 优惠金额
     */
    @TableField(value = "discount_mny")
    private BigDecimal discountMny;
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="sum_settle_tax_mny")
    private java.math.BigDecimal sumSettleTaxMny; // 累计结算金额（含税）
    @TableField(value="sum_settle_mny")
    private java.math.BigDecimal sumSettleMny; // 累计结算金额
    @TableField(value="sum_invoicing_tax_mny")
    private java.math.BigDecimal sumInvoicingTaxMny; // 累计收票（含税）
    @TableField(value="sum_invoicing_mny")
    private java.math.BigDecimal sumInvoicingMny; // 累计收票
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="is_finish")
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    @TableField(value="sum_offset_mny")
    private java.math.BigDecimal sumOffsetMny; // 累计冲抵金额
    @TableField(value="sum_pay_mny")
    private java.math.BigDecimal sumPayMny; // 累计付款金额
    @TableField(value="sum_prepay_mny")
    private java.math.BigDecimal sumPrepayMny; // 累计预付款金额

    @TableField(exist=false)
    @SubEntity(serviceName="otherContractDetailService",pidName = "contractId")
    private List<OtherContractDetailEntity> detailVos = new ArrayList<>(); // 其他支出合同清单
    @TableField(exist=false)
    @SubEntity(serviceName="otherContractPayPlanService",pidName = "contractId")
    private List<OtherContractPayPlanEntity> payPlanVos = new ArrayList<>(); // 其他支出付款计划
    @TableField(exist=false)
    @SubEntity(serviceName="otherContractClauseService",pidName = "contractId")
    private List<OtherContractClauseEntity> clauseVos = new ArrayList<>(); // 其他支出合同条款
    @TableField(value="is_supplement")
    private String isSupplement;

    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    @TableField(value = "depend_on_project")
    private Integer dependOnProject;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    @TableField(value = "purchase_mode")
    private Integer purchaseMode;
    /**
     * 采购方式名称
     */
    @TableField(value = "purchase_mode_name")
    private String purchaseModeName;

    /**
     * 定标结果单id
     */
    @TableField(value = "enquiry_price_bill_id")
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    @TableField(value = "enquiry_price_bill_name")
    private String enquiryPriceBillName;


    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }


    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(Integer purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public String getIsSupplement() {
		return isSupplement;
	}

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    public void setIsSupplement(String isSupplement) {
		this.isSupplement = isSupplement;
	}

	public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public java.math.BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(java.math.BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public java.math.BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(java.math.BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public java.math.BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(java.math.BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public java.math.BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(java.math.BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public java.math.BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(java.math.BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public java.math.BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(java.math.BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 累计结算金额（含税）
     */
    public java.math.BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 累计结算金额（含税）
     */
    public void setSumSettleTaxMny(java.math.BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 累计结算金额
     */
    public java.math.BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    /**
     * 累计结算金额
     */
    public void setSumSettleMny(java.math.BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    /**
     * 累计收票（含税）
     */
    public java.math.BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计收票（含税）
     */
    public void setSumInvoicingTaxMny(java.math.BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计收票
     */
    public java.math.BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计收票
     */
    public void setSumInvoicingMny(java.math.BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public Integer getIsFinish() {
        return isFinish;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public List<OtherContractDetailEntity> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherContractDetailEntity> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherContractPayPlanEntity> getPayPlanVos() {
        return payPlanVos;
    }

    public void setPayPlanVos(List<OtherContractPayPlanEntity> payPlanVos) {
        this.payPlanVos = payPlanVos;
    }

    public List<OtherContractClauseEntity> getClauseVos() {
        return clauseVos;
    }

    public void setClauseVos(List<OtherContractClauseEntity> clauseVos) {
        this.clauseVos = clauseVos;
    }
}
