package com.ejianc.business.othprice.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bidprice.consts.InquiryTypeConsts;
import com.ejianc.business.othprice.bean.PicketageDetailEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteEntity;
import com.ejianc.business.othprice.bean.PicketageSupplierEntity;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageSupplierService;
import com.ejianc.business.othprice.service.InquiryCommonService;
import com.ejianc.business.supplier.api.ISubSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("picketage")
public class PicketageBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IPicketageService service;

	@Autowired
	private IOtherInquiryService inquiryService;
	@Autowired
	private InquiryCommonService inquiryCommonService;

	@Autowired
	private ISubSupplierApi subSupplierApi;

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//自制生成定标结果
		service.pushPicketage(billId);
		service.sendMsg(billId);
		PicketageEntity picketageEntity = service.selectById(billId);
		if (CollectionUtils.isNotEmpty(picketageEntity.getQuoteList())){
			List<PicketageQuoteEntity> quoteList = picketageEntity.getQuoteList();

			List<Long> supplierIds = new ArrayList<>();
			for (PicketageQuoteEntity quoteEntity : quoteList) {
				if (quoteEntity.getBidFlag()==1&&null!=quoteEntity.getSupplierId()){
					supplierIds.add(quoteEntity.getSupplierId());
				}
			}
			if (CollectionUtils.isNotEmpty(supplierIds)){
				CommonResponse<String> stringCommonResponse = subSupplierApi.toBeSubPrice(supplierIds);
				if (!stringCommonResponse.isSuccess()){
					throw new BusinessException(stringCommonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PicketageEntity entity = service.selectById(billId);
		Integer pricingType = entity.getPricingType();
		String inquiryType=String.valueOf(pricingType);
		JSONObject jsonObject = inquiryCommonService.queryContractListByInquiry(null, billId, null, inquiryType);
		if (ObjectUtil.isNotEmpty(jsonObject.get("contractList"))){
			List<JSONObject> list = (List<JSONObject>)jsonObject.get("contractList");
			if (CollectionUtils.isNotEmpty(list)){
				//1-劳务分包；2-专业分包；3-设备采购；4-设备租赁；5-其他
				String msg=null;
				switch (pricingType)
				{
					case 1:
						msg="分包定标被分包合同引用!";
						break;
					case 2:
						msg="分包定标被分包合同引用!";
						break;
					case 3:
						msg="分包定标被设备采购合同引用!";
						break;
					case 4:
						msg="分包定标被设备租赁合同引用!";
						break;
					default:
						msg="分包定标被其他合同引用!";
				}
				return CommonResponse.error(msg);
			}
		}
		service.rollBackPicketage(billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PicketageEntity picketageEntity = service.selectById(billId);
		if (CollectionUtils.isNotEmpty(picketageEntity.getQuoteList())){
			List<PicketageQuoteEntity> quoteList = picketageEntity.getQuoteList();

			List<Long> supplierIds = new ArrayList<>();
			for (PicketageQuoteEntity quoteEntity : quoteList) {
				if (quoteEntity.getBidFlag()==1&&null!=quoteEntity.getSupplierId()){
					supplierIds.add(quoteEntity.getSupplierId());
				}
			}
			if (CollectionUtils.isNotEmpty(supplierIds)){
				CommonResponse<String> stringCommonResponse = subSupplierApi.noBeSubPrice(supplierIds);
				if (!stringCommonResponse.isSuccess()){
					throw new BusinessException(stringCommonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

}
