/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.controller;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteEntity;
import com.ejianc.business.othprice.bean.ShortlistEntity;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IShortlistService;
import com.ejianc.business.othprice.utils.DetailListUtil;
import com.ejianc.business.othprice.utils.FeignUtil;
import com.ejianc.business.othprice.utils.OrgUtil;
import com.ejianc.business.othprice.vo.ShortlistVO;
import com.ejianc.business.supplier.api.ISubSupplierApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"shortlist"})
public class ShortlistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "HK_SHORTLIST";
    @Autowired
    private IShortlistService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private ISubSupplierApi supplierApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private DetailListUtil detailListUtil;
    @Autowired
    private IPicketageService picketageService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ShortlistVO> saveOrUpdate(@RequestBody ShortlistVO saveOrUpdateVO) {
        ShortlistEntity entity = (ShortlistEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ShortlistEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ShortlistVO vo = (ShortlistVO)BeanMapper.map((Object)((Object)entity), ShortlistVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ShortlistVO> queryDetail(Long id) {
        ShortlistEntity entity = (ShortlistEntity)((Object)this.service.selectById(id));
        ShortlistVO vo = (ShortlistVO)BeanMapper.map((Object)((Object)entity), ShortlistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShortlistVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShortlistVO shortlistVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ShortlistVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "biddingMajor"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), ShortlistVO.class);
        Map<Long, String> projectTypeMap = this.feignUtil.getDefdocMap(871033594275971103L);
        Map<Long, String> officeMap = this.feignUtil.getDefdocMap(871034565177655348L);
        records.forEach(vo -> {
            vo.setProjectTypeName(this.feignUtil.getDefDocName(vo.getProjectType(), projectTypeMap));
            vo.setOfficeName(this.feignUtil.getDefDocName(vo.getOffice(), officeMap));
        });
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "biddingMajor"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, ShortlistVO.class);
        Map<Long, String> projectTypeMap = this.feignUtil.getDefdocMap(871033594275971103L);
        Map<Long, String> officeMap = this.feignUtil.getDefdocMap(871034565177655348L);
        records.forEach(vo -> {
            vo.setProjectTypeName(this.feignUtil.getDefDocName(vo.getProjectType(), projectTypeMap));
            vo.setOfficeName(this.feignUtil.getDefDocName(vo.getOffice(), officeMap));
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().exportWithTrans("Shortlist-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refShortlistData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ShortlistVO>> refShortlistData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShortlistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSubSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refSubSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject json = new JSONObject();
        json.put("pageNumber", (Object)pageNumber);
        json.put("pageSize", (Object)pageSize);
        json.put("condition", (Object)condition);
        json.put("searchObject", (Object)searchObject);
        json.put("searchText", (Object)searchText);
        CommonResponse response = this.supplierApi.refSubContractorData(json.getInnerMap());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        Page pageData = (Page)JSON.parseObject((String)((JSONObject)response.getData()).toJSONString(), (TypeReference)new TypeReference<Page<JSONObject>>(){}, (Feature[])new Feature[0]);
        List records = pageData.getRecords();
        List supplierIds = records.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List picketList = this.picketageService.queryList(param);
        this.detailListUtil.setDetailList(picketList);
        List bidList = picketList.stream().map(PicketageEntity::getQuoteList).flatMap(Collection::stream).filter(x -> supplierIds.contains(x.getSupplierId())).collect(Collectors.toList());
        Map<Long, List<PicketageQuoteEntity>> unBidMap = bidList.stream().filter(x -> new Integer(0).equals(x.getBidFlag())).collect(Collectors.groupingBy(x -> x.getSupplierId()));
        List picketageIds = bidList.stream().map(x -> x.getPicketageId()).collect(Collectors.toList());
        List projectIds = picketList.stream().filter(x -> picketageIds.contains(x.getId())).map(x -> x.getProjectId()).distinct().collect(Collectors.toList());
        Map bidMap = bidList.stream().collect(Collectors.groupingBy(x -> x.getSupplierId(), Collectors.mapping(x -> x.getPicketageId(), Collectors.toSet())));
        HashMap map = new HashMap();
        for (Long supplierId : bidMap.keySet()) {
            List ids = picketList.stream().filter(x -> ((Set)bidMap.get(supplierId)).contains(x.getId())).map(x -> x.getProjectId()).distinct().collect(Collectors.toList());
            map.put(supplierId, ids);
        }
        List projectList = new ArrayList();
        if (CollectionUtils.isNotEmpty(projectIds)) {
            CommonResponse projectResp = this.projectApi.queryProjectByIds(projectIds);
            if (!projectResp.isSuccess()) {
                throw new BusinessException(projectResp.getMsg());
            }
            if (null != projectResp.getData()) {
                projectList = (List)projectResp.getData();
            }
        }
        DateTime twoYear = DateUtil.offset((Date)DateUtil.beginOfDay((Date)new Date()), (DateField)DateField.YEAR, (int)-2);
        for (JSONObject vo : records) {
            JSONObject user = this.orgUtil.getCreateUser(vo.getString("createUserCode"));
            vo.put("businessUserId", (Object)user.getLong("id"));
            vo.put("businessUserName", (Object)user.getString("userName"));
            Long supplierId = vo.getLong("id");
            Integer unBidNum = 0;
            if (unBidMap.containsKey(supplierId)) {
                unBidNum = unBidMap.get(supplierId).size();
            }
            vo.put("unBidNum", (Object)unBidNum);
            List<Object> list = new ArrayList();
            if (map.containsKey(supplierId)) {
                list = projectList.stream().filter(x -> ((List)map.get(supplierId)).contains(x.getId())).collect(Collectors.toList());
            }
            String buildProjectName = list.stream().filter(x -> "2".equals(x.getStatus())).map(x -> x.getName()).collect(Collectors.joining(","));
            String finishProjectName = list.stream().filter(arg_0 -> ShortlistController.lambda$refSubSupplierData$17((Date)twoYear, arg_0)).map(x -> x.getName()).collect(Collectors.joining(","));
            vo.put("buildProjectName", (Object)buildProjectName);
            vo.put("finishProjectName", (Object)finishProjectName);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private static /* synthetic */ boolean lambda$refSubSupplierData$17(Date twoYear, ProjectRegisterVO x) {
        return "3".equals(x.getStatus()) && !x.getSignDate().before(twoYear);
    }
}

