/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.OtherQuoteDetailEntity;
import com.ejianc.business.othprice.bean.OtherQuoteEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteDetailEntity;
import com.ejianc.business.othprice.bean.ResultEntity;
import com.ejianc.business.othprice.common.vo.InquiryCommonVO;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IOtherQuoteDetailService;
import com.ejianc.business.othprice.service.IOtherQuoteService;
import com.ejianc.business.othprice.service.IPicketageQuoteDetailService;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IResultService;
import com.ejianc.business.othprice.vo.OtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.business.othprice.vo.OtherQuoteDetailVO;
import com.ejianc.business.othprice.vo.OtherQuoteVO;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inquiryCommonService")
public class InquiryCommonService {
    @Autowired
    private IOtherInquiryService otherInquiryService;
    @Autowired
    private IOtherQuoteService otherQuoteService;
    @Autowired
    private IOtherQuoteDetailService otherQuoteDetailService;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IResultService resultService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPicketageService picketageService;
    @Autowired
    private IPicketageQuoteDetailService picketageQuoteDetailService;

    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType, Boolean picketageFlag) {
        OtherInquiryEntity inquiryEntity = (OtherInquiryEntity)((Object)this.otherInquiryService.selectById(inquiryId));
        OtherInquiryVO materialInquiryVO = (OtherInquiryVO)BeanMapper.map((Object)((Object)inquiryEntity), OtherInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = (InquiryCommonVO)BeanMapper.map((Object)materialInquiryVO, InquiryCommonVO.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OtherQuoteEntity::getInquiryId, (Object)inquiryId);
        queryWrapper.in(OtherQuoteEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.otherQuoteService.list((Wrapper)queryWrapper);
        List otherQuoteVOS = BeanMapper.mapList((Iterable)list, OtherQuoteVO.class);
        inquiryCommonVO.setOtherQuoteVOList(otherQuoteVOS);
        Map<Object, Object> purchaseListMap = new HashMap();
        QueryWrapper quotePurchaseWrapper = new QueryWrapper();
        quotePurchaseWrapper.eq((Object)"inquiry_id", (Object)inquiryId);
        List purchaseDetailEntities = this.picketageQuoteDetailService.list((Wrapper)quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
            purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getQuoteId));
        }
        if (CollectionUtils.isNotEmpty((Collection)otherQuoteVOS)) {
            List quoteIds = otherQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)"quote");
            fileParam.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            Map<Object, Object> fileMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }
            if (!fileMap.isEmpty()) {
                for (OtherQuoteVO quoteVO : otherQuoteVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(quoteVO.getId());
                    if (attachmentVO == null) continue;
                    quoteVO.setQuoteFileId(attachmentVO.getId());
                    quoteVO.setQuoteFileName(attachmentVO.getFileName());
                }
            }
            Map<String, List<OtherQuoteVO>> supplierQuoteMap = otherQuoteVOS.stream().collect(Collectors.groupingBy(OtherQuoteVO::getSocialCreditCode));
            HashMap<Long, String> supplierNameMap = new HashMap<Long, String>();
            for (String key : supplierQuoteMap.keySet()) {
                List<OtherQuoteVO> valueList = supplierQuoteMap.get(key);
                if (valueList.size() > 1) {
                    int i = 1;
                    for (OtherQuoteVO materialQuoteVO : valueList) {
                        String biewVersion = " (\u65b9\u6848" + i++ + ")";
                        String _supplierNameView = materialQuoteVO.getSupplierName() + (String)biewVersion;
                        materialQuoteVO.setSupplierNameView(_supplierNameView);
                        materialQuoteVO.setViewVersion(biewVersion);
                        supplierNameMap.put(materialQuoteVO.getId(), _supplierNameView);
                    }
                    continue;
                }
                OtherQuoteVO quoteVO = valueList.get(0);
                quoteVO.setSupplierNameView(quoteVO.getSupplierName());
                supplierNameMap.put(quoteVO.getId(), quoteVO.getSupplierName());
            }
            if (picketageFlag != null && picketageFlag.booleanValue()) {
                LambdaQueryWrapper picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                picketageEntityLambdaQueryWrapper.eq(PicketageEntity::getInquiryId, (Object)inquiryId);
                List picketageEntities = this.picketageService.list((Wrapper)picketageEntityLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)picketageEntities)) {
                    PicketageEntity picketageEntity = (PicketageEntity)((Object)picketageEntities.get(0));
                    inquiryCommonVO.setId(picketageEntity.getId());
                    inquiryCommonVO.setInquiryDate(picketageEntity.getHandleDate());
                    inquiryCommonVO.setMemo(picketageEntity.getMemo());
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(ResultEntity::getQuoteId, quoteIds);
                List resultEntityList = this.resultService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)resultEntityList)) {
                    BigDecimal sumBidMny = BigDecimal.ZERO;
                    Map<Long, ResultEntity> resultEntityMap = resultEntityList.stream().collect(Collectors.toMap(ResultEntity::getQuoteId, e -> e, (e1, e2) -> e1));
                    for (OtherQuoteVO otherQuoteVO : otherQuoteVOS) {
                        Long quoteVOId = otherQuoteVO.getId();
                        ResultEntity resultEntity = resultEntityMap.get(quoteVOId);
                        if (resultEntity != null) {
                            otherQuoteVO.setSupplierName(resultEntity.getSupplierName());
                            otherQuoteVO.setSupplierNameView((String)supplierNameMap.get(resultEntity.getQuoteId()));
                            otherQuoteVO.setBidFlag(resultEntity.getBidFlag());
                            otherQuoteVO.setBidMny(resultEntity.getBidMny());
                            otherQuoteVO.setBidMemo(resultEntity.getBidMemo());
                            sumBidMny = ComputeUtil.safeAdd((BigDecimal)sumBidMny, (BigDecimal)resultEntity.getBidMny());
                            if (!CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities) || !CollectionUtils.isNotEmpty((Collection)((Collection)purchaseListMap.get(otherQuoteVO.getId())))) continue;
                            otherQuoteVO.setOtherQuoteDetailList(BeanMapper.mapList((Iterable)((Iterable)purchaseListMap.get(otherQuoteVO.getId())), OtherQuoteDetailVO.class));
                            continue;
                        }
                        otherQuoteVO.setBidFlag(Integer.valueOf(0));
                    }
                    inquiryCommonVO.setSumBidMny(sumBidMny);
                }
            }
            LambdaQueryWrapper purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            purchaseDetailEntityLambdaQueryWrapper.in(OtherQuoteDetailEntity::getQuoteId, quoteIds);
            List purchaseDetailEntityList = this.otherQuoteDetailService.list((Wrapper)purchaseDetailEntityLambdaQueryWrapper);
            List otherQuoteDetailVOS = BeanMapper.mapList((Iterable)purchaseDetailEntityList, OtherQuoteDetailVO.class);
            if (CollectionUtils.isNotEmpty((Collection)otherQuoteDetailVOS)) {
                otherQuoteDetailVOS.forEach(t -> t.setSupplierName((String)supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<OtherQuoteDetailVO>> purchaseQuoteMap = otherQuoteDetailVOS.stream().collect(Collectors.groupingBy(OtherQuoteDetailVO::getSourceId));
                List otherInquiryDetailList = inquiryCommonVO.getOtherInquiryDetailList();
                for (OtherInquiryDetailVO otherInquiryDetailVO : otherInquiryDetailList) {
                    List quotePriceList;
                    List<OtherQuoteDetailVO> otherQuoteDetailVOList = purchaseQuoteMap.get(otherInquiryDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(otherQuoteDetailVOList) && CollectionUtils.isNotEmpty(quotePriceList = otherQuoteDetailVOList.stream().filter(t -> t.getPurchaseQuotePrice() != null).map(t -> t.getPurchaseQuotePrice()).collect(Collectors.toList()))) {
                        BigDecimal maxPrice = (BigDecimal)Collections.max(quotePriceList);
                        BigDecimal minPrice = (BigDecimal)Collections.min(quotePriceList);
                        otherInquiryDetailVO.setMinBidPrice(minPrice);
                        otherInquiryDetailVO.setMaxBidPrice(maxPrice);
                    }
                    otherInquiryDetailVO.setOtherQuoteDetailVOList(otherQuoteDetailVOList);
                }
            }
        }
        return inquiryCommonVO;
    }

    public JSONObject queryContractListByInquiry(Long inquiryId, Long picketageId, Integer inquiryState, String inquiryType) {
        PicketageEntity picketageEntity;
        JSONObject resObj = new JSONObject();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(inquiryId != null, ResultEntity::getInquiryId, (Object)inquiryId);
        wrapper.eq(picketageId != null, ResultEntity::getPicketageId, (Object)picketageId);
        List list = this.resultService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resObj;
        }
        LambdaQueryWrapper picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        picketageEntityLambdaQueryWrapper.eq(inquiryId != null, PicketageEntity::getInquiryId, (Object)inquiryId);
        picketageEntityLambdaQueryWrapper.eq(picketageId != null, BaseEntity::getId, (Object)picketageId);
        List picketageEntities = this.picketageService.list((Wrapper)picketageEntityLambdaQueryWrapper);
        PicketageEntity picketageEntity2 = picketageEntity = CollectionUtils.isNotEmpty((Collection)picketageEntities) ? (PicketageEntity)((Object)picketageEntities.get(0)) : null;
        if (picketageEntity != null) {
            resObj.put("picketageId", (Object)picketageEntity.getId());
            resObj.put("bidWinnerId", (Object)picketageEntity.getBidWinnerId());
            resObj.put("bidWinnerName", (Object)picketageEntity.getBidWinnerName());
        }
        Long l = inquiryId = inquiryId != null ? inquiryId : picketageEntity.getInquiryId();
        if (inquiryId != null) {
            OtherInquiryEntity byId = (OtherInquiryEntity)((Object)this.otherInquiryService.getById(inquiryId));
            resObj.put("billCode", (Object)byId.getBillCode());
            resObj.put("billState", (Object)byId.getBillState());
        }
        ArrayList<JSONObject> contractList = new ArrayList<JSONObject>();
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if ("1".equals(inquiryType) || "2".equals(inquiryType)) {
            CommonResponse resp = this.subContractApi.getContractByCondition(ids);
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                for (ContractVO contractVO : (List)resp.getData()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)contractVO.getId());
                    obj.put("code", (Object)contractVO.getBillCode());
                    obj.put("contractName", (Object)contractVO.getContractName());
                    obj.put("supplierName", (Object)contractVO.getSupplierName());
                    obj.put("contractType", (Object)"\u5206\u5305\u5408\u540c");
                    if ("1".equals(inquiryType)) {
                        obj.put("inquiryType", (Object)"\u52b3\u52a1\u5206\u5305");
                    } else {
                        obj.put("inquiryType", (Object)"\u4e13\u4e1a\u5206\u5305");
                    }
                    obj.put("orgName", (Object)contractVO.getOrgName());
                    obj.put("contractMny", (Object)contractVO.getContractTaxMny());
                    if (contractVO.getSignDate() != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        String signDate = format.format(contractVO.getSignDate());
                        obj.put("signDate", (Object)signDate);
                    }
                    obj.put("billStateName", (Object)BillStateEnum.getEnumByStateCode((Integer)contractVO.getBillState()).getDescription());
                    obj.put("billState", (Object)contractVO.getBillState());
                    obj.put("changeStatus", (Object)contractVO.getChangeStatus());
                    obj.put("contractStatus", (Object)contractVO.getContractStatus());
                    contractList.add(obj);
                }
            }
        } else if ("3".equals(inquiryType) || "4".equals(inquiryType) || "5".equals(inquiryType)) {
            // empty if block
        }
        resObj.put("contractList", contractList);
        return resObj;
    }
}

