/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.othprice.bean.OtherQuoteEntity;
import com.ejianc.business.othprice.service.IOtherQuoteService;
import com.ejianc.business.othprice.vo.OtherQuoteVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"otherQuote"})
@Api(tags={"\u62a5\u4ef7\u8bb0\u5f55"})
public class OtherQuoteController
implements Serializable {
    private static final long serialVersionUID = -6476701269896286249L;
    private static final String RULE_CODE = "OTHER_QUOTE";
    private static final String BILL_CODE = "BT202311000002";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IOtherQuoteService service;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IAttachmentApi attachmentApi;

    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<OtherQuoteVO> saveOrUpdate(@RequestBody OtherQuoteVO materialQuoteVO) {
        OtherQuoteEntity entity = (OtherQuoteEntity)((Object)BeanMapper.map((Object)materialQuoteVO, OtherQuoteEntity.class));
        this.service.checkQuoteEndDate(entity.getInquiryId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialQuoteVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OtherQuoteVO vo = (OtherQuoteVO)BeanMapper.map((Object)((Object)entity), OtherQuoteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public CommonResponse<OtherQuoteVO> queryDetail(Long id) {
        OtherQuoteEntity entity = (OtherQuoteEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u4ef7\u8bb0\u5f55\u6570\u636e\uff01");
        }
        OtherQuoteVO vo = (OtherQuoteVO)BeanMapper.map((Object)((Object)entity), OtherQuoteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<OtherQuoteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OtherQuoteVO vo : vos) {
                OtherQuoteEntity otherQuoteEntity = (OtherQuoteEntity)((Object)this.service.selectById(vo.getId()));
                if (otherQuoteEntity.getBillState() == 1) {
                    return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25,\u5df2\u63d0\u4ea4\u7684\u62a5\u4ef7\u5355\u65e0\u6cd5\u5220\u9664");
                }
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<OtherQuoteVO>> queryList(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List materialQuoteVOS = BeanMapper.mapList((Iterable)page.getRecords(), OtherQuoteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) {
            List quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)"quote");
            fileParam.put("sourceTypeList", (Object)JSON.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            Map<Object, Object> fileMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }
            for (OtherQuoteVO materialQuoteVO : materialQuoteVOS) {
                if (!fileMap.containsKey(materialQuoteVO.getId())) continue;
                AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(materialQuoteVO.getId());
                materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
            }
        }
        pageData.setRecords(materialQuoteVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/checkViewAuthority"})
    public CommonResponse<Void> checkViewAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkViewAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/checkQuotationAuthority"})
    public CommonResponse<Void> checkQuotationAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkQuotationAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/fetchVerifyCode"})
    public CommonResponse<Void> fetchVerifyCode(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) throws Exception {
        this.service.fetchVerifyCode(inquiryId, phoneNumber);
        return CommonResponse.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/login"})
    public CommonResponse<String> login(@RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="validate") String validate) {
        this.service.login(phoneNumber, validate);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f\uff01", (Object)phoneNumber);
    }

    @ApiOperation(value="\u6536\u56de")
    @GetMapping(value={"/withdraw"})
    public CommonResponse<String> withdraw(@RequestParam(value="id") Long id) {
        this.service.withdraw(id);
        return CommonResponse.success((String)"\u6536\u56de\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u636e\u72b6\u6001")
    @GetMapping(value={"/changeStatus"})
    public CommonResponse<String> changeStatus(@RequestParam(value="id") Long id, @RequestParam(value="billState") Integer billState) {
        this.service.changeStatus(id, billState);
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6700\u8fd1\u4e00\u6b21\u7684\u62a5\u4ef7\u8bb0\u5f55")
    @GetMapping(value={"/recentQuote"})
    public CommonResponse<OtherQuoteVO> recentQuote(@RequestParam(value="phoneNumber") String phoneNumber) {
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01", (Object)this.service.recentQuote(phoneNumber));
    }
}

