/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteEntity;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.InquiryCommonService;
import com.ejianc.business.supplier.api.ISubSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="picketage")
public class PicketageBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPicketageService service;
    @Autowired
    private IOtherInquiryService inquiryService;
    @Autowired
    private InquiryCommonService inquiryCommonService;
    @Autowired
    private ISubSupplierApi subSupplierApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.service.pushPicketage(billId);
        this.service.sendMsg(billId);
        PicketageEntity picketageEntity = (PicketageEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(picketageEntity.getQuoteList())) {
            CommonResponse stringCommonResponse;
            List<PicketageQuoteEntity> quoteList = picketageEntity.getQuoteList();
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (PicketageQuoteEntity quoteEntity : quoteList) {
                if (quoteEntity.getBidFlag() != 1 || null == quoteEntity.getSupplierId()) continue;
                supplierIds.add(quoteEntity.getSupplierId());
            }
            if (CollectionUtils.isNotEmpty(supplierIds) && !(stringCommonResponse = this.subSupplierApi.toBeSubPrice(supplierIds)).isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List list;
        PicketageEntity entity = (PicketageEntity)((Object)this.service.selectById(billId));
        Integer pricingType = entity.getPricingType();
        String inquiryType = String.valueOf(pricingType);
        JSONObject jsonObject = this.inquiryCommonService.queryContractListByInquiry(null, billId, null, inquiryType);
        if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"contractList")) && CollectionUtils.isNotEmpty((Collection)(list = (List)jsonObject.get((Object)"contractList")))) {
            String msg = null;
            switch (pricingType) {
                case 1: {
                    msg = "\u5206\u5305\u5b9a\u6807\u88ab\u5206\u5305\u5408\u540c\u5f15\u7528!";
                    break;
                }
                case 2: {
                    msg = "\u5206\u5305\u5b9a\u6807\u88ab\u5206\u5305\u5408\u540c\u5f15\u7528!";
                    break;
                }
                case 3: {
                    msg = "\u5206\u5305\u5b9a\u6807\u88ab\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u5f15\u7528!";
                    break;
                }
                case 4: {
                    msg = "\u5206\u5305\u5b9a\u6807\u88ab\u8bbe\u5907\u79df\u8d41\u5408\u540c\u5f15\u7528!";
                    break;
                }
                default: {
                    msg = "\u5206\u5305\u5b9a\u6807\u88ab\u5176\u4ed6\u5408\u540c\u5f15\u7528!";
                }
            }
            return CommonResponse.error((String)msg);
        }
        this.service.rollBackPicketage(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PicketageEntity picketageEntity = (PicketageEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(picketageEntity.getQuoteList())) {
            CommonResponse stringCommonResponse;
            List<PicketageQuoteEntity> quoteList = picketageEntity.getQuoteList();
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (PicketageQuoteEntity quoteEntity : quoteList) {
                if (quoteEntity.getBidFlag() != 1 || null == quoteEntity.getSupplierId()) continue;
                supplierIds.add(quoteEntity.getSupplierId());
            }
            if (CollectionUtils.isNotEmpty(supplierIds) && !(stringCommonResponse = this.subSupplierApi.noBeSubPrice(supplierIds)).isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }
}

