package com.ejianc.business.othprice.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 评标记录表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_othprice_bid_evaluation_record")
public class BidEvaluationRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private String projectId; // 关联项目id
    @TableField(value="first_bid_candidate")
    private String firstBidCandidate; // 第一候选人
    @TableField(value="second_candidate")
    private String secondCandidate; // 第二候选人
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="major")
    private String major; // 专业
    @TableField(value="bid_price")
    private BigDecimal bidPrice; // 拦标价
    @TableField(value="guide_price")
    private BigDecimal guidePrice; // 指导价

    @TableField(value="bill_code")
    private String billCode; // 编码

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @TableField(value="bill_state")
    private Integer billState; // 编码

    @TableField(value="org_id")
    private Long orgId; // 组织id

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<BidCompanyQuotationEntity> getBidCompanyQuotationList() {
        return bidCompanyQuotationList;
    }

    public void setBidCompanyQuotationList(List<BidCompanyQuotationEntity> bidCompanyQuotationList) {
        this.bidCompanyQuotationList = bidCompanyQuotationList;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="bidCompanyQuotationService",pidName = "othpriceBidEvaluationRecordId")
    private List<BidCompanyQuotationEntity> bidCompanyQuotationList = new ArrayList<>(); // 评标记录表子表
    

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getFirstBidCandidate() {
        return firstBidCandidate;
    }

    public void setFirstBidCandidate(String firstBidCandidate) {
        this.firstBidCandidate = firstBidCandidate;
    }
    public String getSecondCandidate() {
        return secondCandidate;
    }

    public void setSecondCandidate(String secondCandidate) {
        this.secondCandidate = secondCandidate;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public BigDecimal getBidPrice() {
        return bidPrice;
    }

    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }
    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }

}
