package com.ejianc.business.othprice.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteDetailEntity;
import com.ejianc.business.othprice.consts.InquiryStateEnum;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IPicketageSupplierService;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageQuoteDetailService;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料定标
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("picketage")
@Api(value = "材料定标", tags = {"材料定标"})
public class PicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPicketageQuoteDetailService purchaseDetailService;
    private static final String BILL_CODE = "OTHER_PICKETAGE";//此处需要根据实际修改

    @Autowired
    private IPicketageService service;
    @Autowired
    private IPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private IOtherInquiryService inquiryService;
    @Autowired
    private SessionManager sessionManager;
//    @Autowired
//    private ICommonBusinessService materialPicketage;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PicketageVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PicketageVO saveOrUpdateVO) {
    	PicketageEntity entity = BeanMapper.map(saveOrUpdateVO, PicketageEntity.class);
    	if (entity.getBidWinMny()!=null){
    	    entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //自制 签订数量
                entity.setContractSign(0);
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getSelfFlag() == null ){
            entity.setSelfFlag(1);
        }
        service.insertOrUpdate(entity);
    	PicketageVO vo = BeanMapper.map(entity, PicketageVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PicketageVO> queryDetail(@RequestParam Long id) {
        PicketageVO vo=service.queryMaterialPicketageDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("参照查询详情")
    @RequestMapping(value = "/queryDetailToRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailToRef(@RequestParam Long id) {
        JSONObject vo=service.queryDetailToRef(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     *  根据询价单 id 查询 询价清单 和报价记录
     * @param inquiryId
     * @return 询价清单--{purchaseList、rentList} 报价记录--{quoteList} 清单数量统计--{totalMap}
     */
    @RequestMapping(value = "/queryByInquiryToDetailAndQuote", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(@RequestParam(value = "inquiryId") String inquiryId){
        return service.queryByInquiryToDetailAndQuote(inquiryId);
    }
    @ApiOperation("新增或者修改参照")
    @RequestMapping(value = "/saveOrUpdateRef", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> saveOrUpdateRef(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PicketageVO saveOrUpdateVO) {
        PicketageEntity entity = BeanMapper.map(saveOrUpdateVO, PicketageEntity.class);
        if (entity.getBidWinMny()!=null){
            entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
        service.checkRefSave(entity);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //自制 签订数量
                entity.setContractSign(0);
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (entity.getSelfFlag() == null) {
            entity.setSelfFlag(1);
        }
        service.insertOrUpdateRef(entity);
        if (entity.getInquiryId() != null) {
            inquiryService.updateInquiry(entity.getInquiryId(), InquiryStateEnum.WIN_STATE.getCode());
        }
        JSONObject vo=service.queryDetailToRef(entity.getId());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PicketageVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            Collection<PicketageEntity> materialPicketageEntities = service.listByIds(vos.stream().map(PicketageVO::getId).collect(Collectors.toList()));
            for (PicketageEntity vo : materialPicketageEntities) {
                if (vo.getSelfFlag()!=1){
                    inquiryService.updateInquiry(vo.getInquiryId(), InquiryStateEnum.EXPIRATION_STATE.getCode());
                }
                QueryWrapper<PicketageQuoteDetailEntity> purchaseWrapper  = new QueryWrapper<>();
                purchaseWrapper.eq("picketage_id",vo.getId());
                purchaseDetailService.remove(purchaseWrapper);
            }
        }
        service.removeByIds(vos.stream().map(PicketageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PicketageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidWinnerName");
        /** 租户隔离 */
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("contractSign")){
            Integer contractSign= Integer.parseInt(params.get("contractSign").getValue().toString());
            params.remove("contractSign");
            if (contractSign==1){
                param.getParams().put("contractSign", new Parameter(QueryParam.GT,0));
            }else {
                param.getParams().put("contractSign", new Parameter(QueryParam.EQ,0));
            }
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<PicketageEntity> page = service.queryPage(param,false);
        IPage<PicketageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PicketageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidWinnerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("contractSign")){
            Integer contractSign= Integer.parseInt(params.get("contractSign").getValue().toString());
            params.remove("contractSign");
            if (contractSign==1){
                param.getParams().put("contractSign", new Parameter(QueryParam.GT,0));
            }else {
                param.getParams().put("contractSign", new Parameter(QueryParam.EQ,0));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PicketageEntity>  list= service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<PicketageVO> vos = BeanMapper.mapList(list, PicketageVO.class);
        if (CollectionUtils.isNotEmpty(vos)){
            for (PicketageVO vo : vos) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
//                ：1-劳务分包；2-专业分包；3-设备采购；4-设备租赁；5-其他
                switch (vo.getPricingType().intValue())
                {
                    case 1:
                        vo.setPricingTypeName("劳务分包");
                        break;
                    case 2:
                        vo.setPricingTypeName("专业分包");
                        break;
                    case 3:
                        vo.setPricingTypeName("设备采购");
                        break;
                    case 4:
                        vo.setPricingTypeName("设备租赁");
                        break;
                    default:
                        vo.setPricingTypeName("其他");
                }
                vo.setPurchaseTypeName(vo.getPurchaseType()==1 ? "项目自采":"公司集采");
                if (ObjectUtil.isNotEmpty(vo.getContractSign())){
                    vo.setContractSignStr(vo.getContractSign()>0 ? vo.getContractSign()+"" : "未签订" );
                }
            }
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("picketage-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialPicketageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PicketageVO>> refMaterialPicketageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PicketageEntity> page = service.queryPage(param,false);
        IPage<PicketageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PicketageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 定标打印模板配置
     * @param detailJsonStr
     * @return
     */
    @PostMapping("/handlePrintDetail")
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        return service.handlePrintDetail(detailJsonStr);
    }


    /**
     * @description: 开发组当月人效
     *
     * @param startDate
     * @param endDate
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2024/11/5
     */
    @RequestMapping(value = "/personBenefit", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> personBenefit(@RequestParam(value = "startDate", required = false) String startDate,
                                                           @RequestParam(value = "endDate", required = false) String endDate) {
        List<Map<String, Object>> obj = service.personBenefit(startDate, endDate);
        return CommonResponse.success("开发组当月人效！", obj);
    }

    /**
     * @description: 劳务招标板块系数统计
     *
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2024/11/5
     */
    @RequestMapping(value = "/competitionNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> competitionNum() {
        List<Map<String, Object>> obj = service.competitionNum();
        return CommonResponse.success("劳务招标板块系数统计！", obj);
    }

    /**
     * @description: 劳务招标任务跟踪数据
     *
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2024/11/5
     */
    @RequestMapping(value = "/taskNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> taskNum(@RequestParam(value = "year", required = false) String year) {
        Map<String, Object> obj = service.taskNum(year);
        return CommonResponse.success("劳务招标任务跟踪数据！", obj);
    }


    /**
     * @description: 当月劳务招标数据一览
     *
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2024/11/5
     */
    @RequestMapping(value = "/bidInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> bidInfo(@RequestParam(value = "startDate", required = false) String startDate,
                                                             @RequestParam(value = "endDate", required = false) String endDate) {
        List<Map<String, Object>> obj = service.bidInfo(startDate, endDate);
        return CommonResponse.success("当月劳务招标数据一览！", obj);
    }
}
