package com.ejianc.business.othprice.controller;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteEntity;
import com.ejianc.business.othprice.bean.ShortlistEntity;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IShortlistService;
import com.ejianc.business.othprice.utils.DetailListUtil;
import com.ejianc.business.othprice.utils.FeignUtil;
import com.ejianc.business.othprice.utils.OrgUtil;
import com.ejianc.business.othprice.vo.ShortlistVO;
import com.ejianc.business.supplier.api.ISubSupplierApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 劳务供应商投标入围
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("shortlist")
public class ShortlistController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HK_SHORTLIST";//此处需要根据实际修改

    @Autowired
    private IShortlistService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private FeignUtil feignUtil;

    @Autowired
    private ISubSupplierApi supplierApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private DetailListUtil detailListUtil;

    @Autowired
    private IPicketageService picketageService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShortlistVO> saveOrUpdate(@RequestBody ShortlistVO saveOrUpdateVO) {
    	ShortlistEntity entity = BeanMapper.map(saveOrUpdateVO, ShortlistEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	entity.getShortlistDetailList().forEach(detail -> {
            detail.setReferencedFlag(0);
        });
    	service.saveOrUpdate(entity, false);
    	ShortlistVO vo = BeanMapper.map(entity, ShortlistVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShortlistVO> queryDetail(Long id) {
    	ShortlistEntity entity = service.selectById(id);
    	ShortlistVO vo = BeanMapper.map(entity, ShortlistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShortlistVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ShortlistVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ShortlistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShortlistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "biddingMajor"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ShortlistEntity> page = service.queryPage(param,false);
        IPage<ShortlistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ShortlistVO> records = BeanMapper.mapList(page.getRecords(), ShortlistVO.class);
        Map<Long, String> projectTypeMap = feignUtil.getDefdocMap(871033594275971103L);
        Map<Long, String> officeMap = feignUtil.getDefdocMap(871034565177655348L);
        records.forEach(vo->{
            vo.setProjectTypeName(feignUtil.getDefDocName(vo.getProjectType(), projectTypeMap));
            vo.setOfficeName(feignUtil.getDefDocName(vo.getOffice(), officeMap));
        });
  		pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "biddingMajor"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ShortlistEntity> list = service.queryList(param);
        List<ShortlistVO> records = BeanMapper.mapList(list, ShortlistVO.class);
        Map<Long, String> projectTypeMap = feignUtil.getDefdocMap(871033594275971103L);
        Map<Long, String> officeMap = feignUtil.getDefdocMap(871034565177655348L);
        records.forEach(vo->{
            vo.setProjectTypeName(feignUtil.getDefDocName(vo.getProjectType(), projectTypeMap));
            vo.setOfficeName(feignUtil.getDefDocName(vo.getOffice(), officeMap));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().exportWithTrans("Shortlist-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refShortlistData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShortlistVO>> refShortlistData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ShortlistEntity> page = service.queryPage(param,false);
        IPage<ShortlistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShortlistVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSubSupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refSubSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        JSONObject json = new JSONObject();
        json.put("pageNumber", pageNumber);
        json.put("pageSize", pageSize);
        json.put("condition", condition);
        json.put("searchObject", searchObject);
        json.put("searchText", searchText);
        CommonResponse<JSONObject> response = supplierApi.refSubContractorData(json.getInnerMap());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        Page<JSONObject> pageData = JSON.parseObject(response.getData().toJSONString(), new TypeReference<Page<JSONObject>>(){});
        List<JSONObject> records = pageData.getRecords();
        List<Long> supplierIds = records.stream().map(x->x.getLong("id")).collect(Collectors.toList());

        // 劳务招采定标
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<PicketageEntity> picketList = picketageService.queryList(param);
        detailListUtil.setDetailList(picketList);
        List<PicketageQuoteEntity> bidList = picketList.stream().map(PicketageEntity::getQuoteList).flatMap(Collection::stream).
                filter(x->supplierIds.contains(x.getSupplierId())).collect(Collectors.toList());
        Map<Long, List<PicketageQuoteEntity>> unBidMap = bidList.stream().filter(x->new Integer(0).equals(x.getBidFlag())).
                collect(Collectors.groupingBy(x->x.getSupplierId()));

        // 项目按照供应商主键分组
        List<Long> picketageIds = bidList.stream().map(x->x.getPicketageId()).collect(Collectors.toList());
        List<Long> projectIds = picketList.stream().filter(x->picketageIds.contains(x.getId())).map(x->x.getProjectId()).distinct().collect(Collectors.toList());
        Map<Long, Set<Long>> bidMap = bidList.stream().collect(Collectors.groupingBy(x->x.getSupplierId(), Collectors.mapping(x->x.getPicketageId(), Collectors.toSet())));
        Map<Long, List<Long>> map = new HashMap<>();
        for(Long supplierId : bidMap.keySet()){
            List<Long> ids = picketList.stream().filter(x->bidMap.get(supplierId).contains(x.getId())).map(x->x.getProjectId()).distinct().collect(Collectors.toList());
            map.put(supplierId, ids);
        }

        // 项目
        List<ProjectRegisterVO> projectList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIds)){
            CommonResponse<List<ProjectRegisterVO>> projectResp = projectApi.queryProjectByIds(projectIds);
            if(!projectResp.isSuccess()){
                throw new BusinessException(projectResp.getMsg());
            }
            if(null != projectResp.getData()){
                projectList = projectResp.getData();
            }
        }

        // 汇总
        Date twoYear = DateUtil.offset(DateUtil.beginOfDay(new Date()), DateField.YEAR, -2);
        for(JSONObject vo : records){
            JSONObject user = orgUtil.getCreateUser(vo.getString("createUserCode"));
            vo.put("businessUserId", user.getLong("id"));
            vo.put("businessUserName", user.getString("userName"));

            Long supplierId = vo.getLong("id");
            Integer unBidNum = 0;
            if(unBidMap.containsKey(supplierId)){
                unBidNum = unBidMap.get(supplierId).size();
            }
            vo.put("unBidNum", unBidNum);

            List<ProjectRegisterVO> list = new ArrayList<>();
            if(map.containsKey(supplierId)){
                list = projectList.stream().filter(x->map.get(supplierId).contains(x.getId())).collect(Collectors.toList());
            }
            String buildProjectName = list.stream().filter(x->"2".equals(x.getStatus())).map(x->x.getName()).collect(Collectors.joining(","));
            String finishProjectName = list.stream().filter(x->"3".equals(x.getStatus()) && !x.getSignDate().before(twoYear)).map(x->x.getName()).collect(Collectors.joining(","));
            vo.put("buildProjectName", buildProjectName);
            vo.put("finishProjectName", finishProjectName);
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
