package com.ejianc.business.othprice.controller.api;

import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.vo.PicketageQuoteVO;
import com.ejianc.business.othprice.vo.SubContractorBidVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;


@RestController
@RequestMapping("/api/otherInquiry")
public class IOtherInquiryApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPicketageService picketageService;


    /**
     * @Description 获取供应商投标信息
     * 投标数
     * 中标数
     * 未中标数
     * 历史平均投标系数
     * 历史平均中标系数
     */
    @GetMapping(value = "getSubContractorBidInfo")
    public CommonResponse<SubContractorBidVO> getSubContractorBidInfo(@RequestParam(value = "supplierId") Long supplierId) {
        List<PicketageQuoteVO> list = picketageService.getSubContractorBidList(supplierId);
        SubContractorBidVO subContractorBidVO = new SubContractorBidVO();
        if (CollectionUtils.isNotEmpty(list)) {
            Integer bidNum = list.size(); // 投标数
            Integer winBidNum = 0; // 中标数
            BigDecimal bidFactorSum = BigDecimal.ZERO; // 历史投标系数总计
            BigDecimal winBidFactorSum = BigDecimal.ZERO; // 历史中标系数总计
            for (PicketageQuoteVO picketageQuoteVO : list) {
                Integer bidFlag = picketageQuoteVO.getBidFlag();
                BigDecimal competitionNum = picketageQuoteVO.getCompetitionNum();
                if (bidFlag != null && bidFlag.intValue() == 1) {
                    winBidNum++;
                    winBidFactorSum = ComputeUtil.safeAdd(winBidFactorSum, competitionNum);
                }
                bidFactorSum = ComputeUtil.safeAdd(bidFactorSum, competitionNum);
            }
            subContractorBidVO.setBidNum(bidNum);
            subContractorBidVO.setWinBidNum(winBidNum);
            subContractorBidVO.setLoseBidNum(bidNum - winBidNum);
            subContractorBidVO.setAvgBidFactor(ComputeUtil.safeDiv(bidFactorSum, ComputeUtil.toBigDecimal(bidNum)));
            subContractorBidVO.setAvgWinBidFactor(ComputeUtil.safeDiv(winBidFactorSum, ComputeUtil.toBigDecimal(winBidNum)));
        }
        return CommonResponse.success(subContractorBidVO);
    }

}
