package com.ejianc.business.othprice.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.OtherInquirySupplierEntity;
import com.ejianc.business.othprice.consts.InquiryStateEnum;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IShortlistDetailService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("otherInquiry")
public class OtherInquiryBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOtherInquiryService otherInquiryService;
    @Autowired
    private IShortlistDetailService shortlistDetailService;


	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInquiryEntity entity = otherInquiryService.selectById(billId);
		if(entity!=null){
			LambdaUpdateWrapper<OtherInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(OtherInquiryEntity::getId,entity.getId());
			updateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.QUOTATION_STATE.getCode());
			otherInquiryService.update(updateWrapper);
		}
		//回写供应商
		if (CollectionUtils.isNotEmpty(entity.getOtherInquirySupplierList())){
			List<OtherInquirySupplierEntity> otherInquirySupplierList = entity.getOtherInquirySupplierList();
			List<Long> collect = otherInquirySupplierList.stream().filter(e -> null != e.getSourceShortId()).map(e -> e.getSourceShortId()).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(collect)){
				shortlistDetailService.updateShortlistDetail(collect,1);
				}
			}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInquiryEntity entity = otherInquiryService.selectById(billId);
		if(entity!=null){
			LambdaUpdateWrapper<OtherInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(OtherInquiryEntity::getId,entity.getId());
			updateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.DEFAULT_STATE.getCode());
			otherInquiryService.update(updateWrapper);
		}
		if (CollectionUtils.isNotEmpty(entity.getOtherInquirySupplierList())){
			List<OtherInquirySupplierEntity> otherInquirySupplierList = entity.getOtherInquirySupplierList();
			List<Long> collect = otherInquirySupplierList.stream().filter(e -> null != e.getSourceShortId()).map(e -> e.getSourceShortId()).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(collect)){
				shortlistDetailService.updateShortlistDetail(collect,0);
			}
		}
		return CommonResponse.success();
	}

}
